/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.measure.internal;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.measure.MeasureBuilder;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;

public class DefaultMeasureBuilder<G extends Serializable>
implements MeasureBuilder<G> {
    boolean onProject = false;
    InputFile file;
    Metric<G> metric;
    G value;

    @Override
    public DefaultMeasureBuilder<G> onFile(InputFile inputFile) {
        Preconditions.checkState((!this.onProject ? 1 : 0) != 0, (Object)"onProject already called");
        Preconditions.checkState((this.file == null ? 1 : 0) != 0, (Object)"onFile already called");
        Preconditions.checkNotNull((Object)inputFile, (Object)"InputFile should be non null");
        this.file = inputFile;
        return this;
    }

    @Override
    public DefaultMeasureBuilder<G> onProject() {
        Preconditions.checkState((!this.onProject ? 1 : 0) != 0, (Object)"onProject already called");
        Preconditions.checkState((this.file == null ? 1 : 0) != 0, (Object)"onFile already called");
        this.onProject = true;
        return this;
    }

    @Override
    public DefaultMeasureBuilder<G> forMetric(Metric<G> metric) {
        Preconditions.checkState((metric != null ? 1 : 0) != 0, (Object)"Metric already defined");
        Preconditions.checkNotNull(metric, (Object)"metric should be non null");
        this.metric = metric;
        return this;
    }

    @Override
    public DefaultMeasureBuilder<G> withValue(G value) {
        Preconditions.checkState((this.value == null ? 1 : 0) != 0, (Object)"Measure value already defined");
        Preconditions.checkNotNull(value, (Object)"Measure value can't be null");
        this.value = value;
        return this;
    }

    @Override
    public DefaultMeasure<G> build() {
        DefaultMeasure result = new DefaultMeasure(this);
        this.reset();
        return result;
    }

    private void reset() {
        this.onProject = false;
        this.file = null;
        this.metric = null;
        this.value = null;
    }
}

