/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.MessageException;

public class RulesProfile
implements Cloneable {
    @Deprecated
    public static final String SONAR_WAY_NAME = "Sonar way";
    @Deprecated
    public static final String SONAR_WAY_FINDBUGS_NAME = "Sonar way with Findbugs";
    @Deprecated
    public static final String SUN_CONVENTIONS_NAME = "Sun checks";
    private String name;
    private Boolean defaultProfile = Boolean.FALSE;
    private String language;
    private String parentName;
    private List<ActiveRule> activeRules = Lists.newArrayList();

    @Deprecated
    public RulesProfile() {
    }

    @Deprecated
    public RulesProfile(String name, String language) {
        this.name = name;
        this.language = language;
        this.activeRules = Lists.newArrayList();
    }

    @Deprecated
    public RulesProfile(String name, String language, boolean defaultProfile, boolean provided) {
        this(name, language);
        this.defaultProfile = defaultProfile;
    }

    public Integer getId() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public RulesProfile setName(String s) {
        this.name = s;
        return this;
    }

    @Deprecated
    public int getVersion() {
        return -1;
    }

    @Deprecated
    public RulesProfile setVersion(int version) {
        return this;
    }

    @CheckForNull
    @Deprecated
    public Boolean getUsed() {
        return null;
    }

    @Deprecated
    public RulesProfile setUsed(Boolean used) {
        return this;
    }

    public List<ActiveRule> getActiveRules() {
        return this.getActiveRules(false);
    }

    public List<ActiveRule> getActiveRules(boolean acceptDisabledRules) {
        if (acceptDisabledRules) {
            return this.activeRules;
        }
        ArrayList result = Lists.newArrayList();
        for (ActiveRule activeRule : this.activeRules) {
            if (!activeRule.isEnabled()) continue;
            result.add(activeRule);
        }
        return result;
    }

    public RulesProfile removeActiveRule(ActiveRule activeRule) {
        this.activeRules.remove(activeRule);
        return this;
    }

    public RulesProfile addActiveRule(ActiveRule activeRule) {
        this.activeRules.add(activeRule);
        return this;
    }

    public void setActiveRules(List<ActiveRule> activeRules) {
        this.activeRules = activeRules;
    }

    public Boolean getDefaultProfile() {
        return this.defaultProfile;
    }

    public void setDefaultProfile(Boolean b) {
        this.defaultProfile = b;
    }

    @Deprecated
    public Boolean getProvided() {
        return false;
    }

    @Deprecated
    public void setProvided(Boolean b) {
    }

    @Deprecated
    public Boolean getEnabled() {
        return Boolean.TRUE;
    }

    @Deprecated
    public boolean isEnabled() {
        return true;
    }

    @Deprecated
    public RulesProfile setEnabled(Boolean b) {
        throw new UnsupportedOperationException("The field RulesProfile#enabled is not supported since 3.3.");
    }

    public String getLanguage() {
        return this.language;
    }

    public RulesProfile setLanguage(String s) {
        this.language = s;
        return this;
    }

    @CheckForNull
    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public List<ActiveRule> getActiveRules(RulePriority severity) {
        ArrayList result = Lists.newArrayList();
        for (ActiveRule activeRule : this.activeRules) {
            if (!activeRule.getSeverity().equals((Object)severity) || !activeRule.isEnabled()) continue;
            result.add(activeRule);
        }
        return result;
    }

    @Deprecated
    public List<ActiveRule> getActiveRulesByPlugin(String repositoryKey) {
        return this.getActiveRulesByRepository(repositoryKey);
    }

    public List<ActiveRule> getActiveRulesByRepository(String repositoryKey) {
        ArrayList result = Lists.newArrayList();
        for (ActiveRule activeRule : this.activeRules) {
            if (!repositoryKey.equals(activeRule.getRepositoryKey()) || !activeRule.isEnabled()) continue;
            result.add(activeRule);
        }
        return result;
    }

    @CheckForNull
    public ActiveRule getActiveRule(String repositoryKey, String ruleKey) {
        for (ActiveRule activeRule : this.activeRules) {
            if (!StringUtils.equals((String)activeRule.getRepositoryKey(), (String)repositoryKey) || !StringUtils.equals((String)activeRule.getRuleKey(), (String)ruleKey) || !activeRule.isEnabled()) continue;
            return activeRule;
        }
        return null;
    }

    @CheckForNull
    public ActiveRule getActiveRuleByConfigKey(String repositoryKey, String configKey) {
        for (ActiveRule activeRule : this.activeRules) {
            if (!StringUtils.equals((String)activeRule.getRepositoryKey(), (String)repositoryKey) || !StringUtils.equals((String)activeRule.getConfigKey(), (String)configKey) || !activeRule.isEnabled()) continue;
            return activeRule;
        }
        return null;
    }

    @CheckForNull
    public ActiveRule getActiveRule(Rule rule) {
        return this.getActiveRule(rule.getRepositoryKey(), rule.getKey());
    }

    public ActiveRule activateRule(final Rule rule, @Nullable RulePriority optionalSeverity) {
        if (Iterables.any(this.activeRules, (Predicate)new Predicate<ActiveRule>(){

            public boolean apply(ActiveRule input) {
                return input.getRule().equals(rule);
            }
        })) {
            throw MessageException.of(String.format("The definition of the profile '%s' (language '%s') contains multiple occurrences of the '%s:%s' rule. The plugin which declares this profile should fix this.", this.getName(), this.getLanguage(), rule.getRepositoryKey(), rule.getKey()));
        }
        ActiveRule activeRule = new ActiveRule();
        activeRule.setRule(rule);
        activeRule.setRulesProfile(this);
        activeRule.setSeverity(optionalSeverity == null ? rule.getSeverity() : optionalSeverity);
        this.activeRules.add(activeRule);
        return activeRule;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RulesProfile)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RulesProfile other = (RulesProfile)obj;
        return new EqualsBuilder().append((Object)this.language, (Object)other.getLanguage()).append((Object)this.name, (Object)other.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.language).append((Object)this.name).toHashCode();
    }

    public Object clone() {
        RulesProfile clone = RulesProfile.create(this.getName(), this.getLanguage());
        clone.setDefaultProfile(this.getDefaultProfile());
        clone.setParentName(this.getParentName());
        if (this.activeRules != null && !this.activeRules.isEmpty()) {
            clone.setActiveRules(new ArrayList<ActiveRule>(CollectionUtils.collect(this.activeRules, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ((ActiveRule)input).clone();
                }
            })));
        }
        return clone;
    }

    public String toString() {
        return "[name=" + this.name + ",language=" + this.language + "]";
    }

    public static RulesProfile create(String name, String language) {
        return new RulesProfile().setName(name).setLanguage(language);
    }

    public static RulesProfile create() {
        return new RulesProfile();
    }
}

