/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.measure.internal;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasureBuilder;

public class DefaultMeasure<G extends Serializable>
implements Measure<G>,
Serializable {
    private final InputFile inputFile;
    private final Metric<G> metric;
    private final G value;

    DefaultMeasure(DefaultMeasureBuilder<G> builder) {
        Preconditions.checkNotNull(builder.value, (Object)"Measure value can't be null");
        Preconditions.checkNotNull(builder.metric, (Object)"Measure metric can't be null");
        Preconditions.checkState((boolean)builder.metric.valueType().equals(builder.value.getClass()), (Object)("Measure value should be of type " + builder.metric.valueType()));
        this.inputFile = builder.file;
        this.metric = builder.metric;
        this.value = builder.value;
    }

    @Override
    @CheckForNull
    public InputFile inputFile() {
        return this.inputFile;
    }

    @Override
    public Metric<G> metric() {
        return this.metric;
    }

    @Override
    public G value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultMeasure rhs = (DefaultMeasure)obj;
        return new EqualsBuilder().append((Object)this.inputFile, (Object)rhs.inputFile).append(this.metric, rhs.metric).append(this.value, rhs.value).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(27, 45).append((Object)this.inputFile).append(this.metric).append(this.value).toHashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

