/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.api.resources.Language;

public class Languages
implements BatchComponent,
ServerComponent {
    private static final Logger LOG = LoggerFactory.getLogger(Languages.class);
    private final Map<String, Language> map = Maps.newLinkedHashMap();

    public Languages(Language ... languages) {
        LOG.debug("Available languages:");
        for (Language language : languages) {
            this.map.put(language.getKey(), language);
            LOG.debug("  * " + language.getName() + " => \"" + language.getKey() + "\"");
        }
    }

    public Languages() {
        LOG.debug("No language available");
    }

    public String[] getSuffixes(String ... keys) {
        ArrayList<String> suffixes = new ArrayList<String>();
        for (Map.Entry<String, Language> entry : this.map.entrySet()) {
            if (!ArrayUtils.isEmpty((Object[])keys) && !ArrayUtils.contains((Object[])keys, (Object)entry.getKey())) continue;
            suffixes.addAll(Arrays.asList(entry.getValue().getFileSuffixes()));
        }
        return suffixes.toArray(new String[suffixes.size()]);
    }

    public Language get(String key) {
        return this.map.get(key);
    }

    public void add(Language language) {
        this.map.put(language.getKey(), language);
    }

    public Language[] all() {
        Collection<Language> languages = this.map.values();
        return languages.toArray(new Language[languages.size()]);
    }
}

