/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Collections;
import java.util.List;
import org.sonar.api.measures.Formula;
import org.sonar.api.measures.FormulaContext;
import org.sonar.api.measures.FormulaData;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;

public class SumChildValuesFormula
implements Formula {
    private boolean saveZeroIfNoChildValues;

    public SumChildValuesFormula(boolean saveZeroIfNoChildValues) {
        this.saveZeroIfNoChildValues = saveZeroIfNoChildValues;
    }

    @Override
    public List<Metric> dependsUponMetrics() {
        return Collections.emptyList();
    }

    @Override
    public Measure calculate(FormulaData data, FormulaContext context) {
        Double sum = MeasureUtils.sum(this.saveZeroIfNoChildValues, data.getChildrenMeasures(context.getTargetMetric()));
        if (sum != null) {
            return new Measure(context.getTargetMetric(), sum);
        }
        return null;
    }
}

