/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.io.File;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.WildcardPattern;

public class Directory
extends Resource {
    public static final String SEPARATOR = "/";
    public static final String ROOT = "[root]";

    Directory() {
    }

    @Deprecated
    public Directory(String relativePathFromSourceDir) {
        this(relativePathFromSourceDir, null);
    }

    @Deprecated
    public Directory(String relativePathFromSourceDir, Language language) {
        this.setDeprecatedKey(Directory.parseKey(relativePathFromSourceDir));
    }

    @Override
    public String getName() {
        return this.getKey();
    }

    @Override
    public String getLongName() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Language getLanguage() {
        return null;
    }

    @Override
    public String getScope() {
        return "DIR";
    }

    @Override
    public String getQualifier() {
        return "DIR";
    }

    @Override
    public Resource getParent() {
        return null;
    }

    @Override
    public boolean matchFilePattern(String antPattern) {
        WildcardPattern matcher = WildcardPattern.create(antPattern, SEPARATOR);
        return matcher.match(this.getKey());
    }

    public static String parseKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            return ROOT;
        }
        String normalizedKey = key;
        normalizedKey = normalizedKey.replace('\\', '/');
        normalizedKey = StringUtils.trim((String)normalizedKey);
        normalizedKey = StringUtils.removeStart((String)normalizedKey, (String)SEPARATOR);
        normalizedKey = StringUtils.removeEnd((String)normalizedKey, (String)SEPARATOR);
        return normalizedKey;
    }

    @CheckForNull
    public static Directory fromIOFile(File dir, Project module) {
        String relativePathFromBasedir = new PathResolver().relativePath(module.getFileSystem().getBasedir(), dir);
        if (relativePathFromBasedir != null) {
            return Directory.create(relativePathFromBasedir);
        }
        return null;
    }

    public static Directory create(String relativePathFromBaseDir) {
        Directory d = new Directory();
        String normalizedPath = Directory.normalize(relativePathFromBaseDir);
        d.setKey(normalizedPath == null ? SEPARATOR : normalizedPath);
        d.setPath(normalizedPath == null ? "" : normalizedPath);
        return d;
    }

    public static Directory create(String relativePathFromBaseDir, String relativePathFromSourceDir) {
        Directory d = Directory.create(relativePathFromBaseDir);
        d.setDeprecatedKey(Directory.parseKey(relativePathFromSourceDir));
        return d;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.getKey()).append("deprecatedKey", (Object)this.getDeprecatedKey()).append("path", (Object)this.getPath()).toString();
    }
}

