/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@Deprecated
public final class WorkUnit
implements Serializable {
    public static final String DAYS = "d";
    public static final String MINUTES = "mn";
    public static final String HOURS = "h";
    public static final String DEFAULT_UNIT = "d";
    private static final String[] UNITS = new String[]{"d", "mn", "h"};
    public static final double DEFAULT_VALUE = 0.0;
    private double value = 0.0;
    private String unit = "d";

    WorkUnit(double value, String unit) {
        this.value = value;
        this.unit = unit;
    }

    public double getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public static WorkUnit create(@Nullable Double value, @Nullable String unit) {
        double d;
        String defaultIfEmptyUnit = StringUtils.defaultIfEmpty((String)unit, (String)"d");
        if (!ArrayUtils.contains((Object[])UNITS, (Object)defaultIfEmptyUnit)) {
            throw new IllegalArgumentException("Unit can not be: " + defaultIfEmptyUnit + ". Possible values are " + ArrayUtils.toString((Object)UNITS));
        }
        double d2 = d = value != null ? value : 0.0;
        if (d < 0.0) {
            throw new IllegalArgumentException("Value can not be negative: " + d);
        }
        return new WorkUnit(d, defaultIfEmptyUnit);
    }

    public static WorkUnit create() {
        return WorkUnit.create(0.0, "d");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkUnit workUnit = (WorkUnit)o;
        if (Double.compare(workUnit.value, this.value) != 0) {
            return false;
        }
        return this.unit.equals(workUnit.unit);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.value);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + this.unit.hashCode();
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

