/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.servlet.Filter;
import org.sonar.api.ServerExtension;

public abstract class ServletFilter
implements ServerExtension,
Filter {
    public UrlPattern doGetPattern() {
        return UrlPattern.create("/*");
    }

    public static final class UrlPattern {
        private int code;
        private String url;
        private String urlToMatch;

        public static UrlPattern create(String pattern) {
            return new UrlPattern(pattern);
        }

        private UrlPattern(String url) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0, (Object)"Empty url");
            this.url = url;
            this.urlToMatch = url.replaceAll("/?\\*", "");
            this.code = "/*".equals(url) ? 1 : (url.startsWith("*") ? 2 : (url.endsWith("*") ? 3 : 4));
        }

        public boolean matches(String path) {
            switch (this.code) {
                case 1: {
                    return true;
                }
                case 2: {
                    return path.endsWith(this.urlToMatch);
                }
                case 3: {
                    return path.startsWith(this.urlToMatch);
                }
            }
            return path.equals(this.urlToMatch);
        }

        public String getUrl() {
            return this.url;
        }

        public String toString() {
            return this.url;
        }
    }
}

