/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.database.BaseIdentifiable;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.utils.DateUtils;

@Entity
@Table(name="events")
public class Event
extends BaseIdentifiable {
    public static final String CATEGORY_VERSION = "Version";
    public static final String CATEGORY_ALERT = "Alert";
    public static final String CATEGORY_PROFILE = "Profile";
    @Column(name="name", updatable=true, nullable=true, length=400)
    private String name;
    @Column(name="description", updatable=true, nullable=true, length=4000)
    private String description;
    @Column(name="category", updatable=true, nullable=true, length=50)
    private String category;
    @Column(name="event_date", updatable=true, nullable=false)
    private Long date;
    @Column(name="created_at", updatable=true, nullable=false)
    private Long createdAt;
    @Column(name="event_data", updatable=true, nullable=true)
    private String data;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="snapshot_id", updatable=true, nullable=true)
    private Snapshot snapshot;
    @Column(name="resource_id", updatable=true, nullable=true)
    private Integer resourceId;

    public Event() {
    }

    public Event(String name, String description, String category) {
        this.name = name;
        this.description = description;
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean isVersionCategory() {
        return CATEGORY_VERSION.equalsIgnoreCase(this.category);
    }

    public boolean isProfileCategory() {
        return CATEGORY_PROFILE.equalsIgnoreCase(this.category);
    }

    public Date getDate() {
        return DateUtils.longToDate(this.date);
    }

    public void setDate(Date date) {
        this.date = date.getTime();
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public Date getCreatedAt() {
        return new Date(this.createdAt);
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt.getTime();
    }

    public final void setSnapshot(Snapshot snapshot) {
        this.snapshot = (Snapshot)Preconditions.checkNotNull((Object)snapshot, (Object)"it is not possible to set a null snapshot linked to an event");
        this.date = snapshot.getCreatedAtMs();
        this.resourceId = snapshot.getResourceId();
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public Event setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("categ", (Object)this.category).append("date", (Object)this.date).append("snapshot", (Object)this.snapshot).append("resource", (Object)this.resourceId).toString();
    }
}

