/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.bootstrap;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class ProjectDefinition {
    public static final String SOURCES_PROPERTY = "sonar.sources";
    @Deprecated
    public static final String SOURCE_DIRS_PROPERTY = "sonar.sources";
    @Deprecated
    public static final String SOURCE_FILES_PROPERTY = "sonar.sourceFiles";
    public static final String TESTS_PROPERTY = "sonar.tests";
    @Deprecated
    public static final String TEST_DIRS_PROPERTY = "sonar.tests";
    @Deprecated
    public static final String TEST_FILES_PROPERTY = "sonar.testFiles";
    @Deprecated
    public static final String BINARIES_PROPERTY = "sonar.binaries";
    @Deprecated
    public static final String LIBRARIES_PROPERTY = "sonar.libraries";
    public static final String BUILD_DIR_PROPERTY = "sonar.buildDir";
    private static final char SEPARATOR = ',';
    private File baseDir;
    private File workDir;
    private File buildDir;
    private Map<String, String> properties = new HashMap<String, String>();
    private ProjectDefinition parent = null;
    private List<ProjectDefinition> subProjects = Lists.newArrayList();
    private List<Object> containerExtensions = Lists.newArrayList();

    private ProjectDefinition(Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            this.properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    @Deprecated
    public static ProjectDefinition create(Properties properties) {
        return new ProjectDefinition(properties);
    }

    public static ProjectDefinition create() {
        return new ProjectDefinition(new Properties());
    }

    public ProjectDefinition setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public ProjectDefinition setWorkDir(@Nullable File workDir) {
        this.workDir = workDir;
        return this;
    }

    @CheckForNull
    public File getWorkDir() {
        return this.workDir;
    }

    public ProjectDefinition setBuildDir(@Nullable File d) {
        this.buildDir = d;
        return this;
    }

    @CheckForNull
    public File getBuildDir() {
        return this.buildDir;
    }

    @Deprecated
    public Properties getProperties() {
        Properties result = new Properties();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            result.setProperty(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    @Deprecated
    public ProjectDefinition setProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return this;
    }

    public ProjectDefinition setProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public ProjectDefinition setProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public ProjectDefinition setKey(String key) {
        this.properties.put("sonar.projectKey", key);
        return this;
    }

    public ProjectDefinition setVersion(String s) {
        this.properties.put("sonar.projectVersion", StringUtils.defaultString((String)s));
        return this;
    }

    public ProjectDefinition setName(String s) {
        this.properties.put("sonar.projectName", StringUtils.defaultString((String)s));
        return this;
    }

    public ProjectDefinition setDescription(String s) {
        this.properties.put("sonar.projectDescription", StringUtils.defaultString((String)s));
        return this;
    }

    public String getKey() {
        return this.properties.get("sonar.projectKey");
    }

    public String getKeyWithBranch() {
        String branch = this.getBranch();
        String projectKey = this.getKey();
        if (StringUtils.isNotBlank((String)branch)) {
            projectKey = String.format("%s:%s", projectKey, branch);
        }
        return projectKey;
    }

    @CheckForNull
    private String getBranch() {
        String branch = this.properties.get("sonar.branch");
        if (StringUtils.isNotBlank((String)branch)) {
            return branch;
        }
        if (this.getParent() != null) {
            return this.getParent().getBranch();
        }
        return null;
    }

    public String getVersion() {
        return this.properties.get("sonar.projectVersion");
    }

    public String getName() {
        String name = this.properties.get("sonar.projectName");
        if (StringUtils.isBlank((String)name)) {
            name = "Unnamed - " + this.getKey();
        }
        return name;
    }

    public String getDescription() {
        return this.properties.get("sonar.projectDescription");
    }

    private void appendProperty(String key, String value) {
        String current = (String)ObjectUtils.defaultIfNull((Object)this.properties.get(key), (Object)"");
        if (StringUtils.isBlank((String)current)) {
            this.properties.put(key, value);
        } else {
            this.properties.put(key, current + ',' + value);
        }
    }

    public List<String> sources() {
        String sources = (String)ObjectUtils.defaultIfNull((Object)this.properties.get("sonar.sources"), (Object)"");
        return ProjectDefinition.trim(StringUtils.split((String)sources, (char)','));
    }

    @Deprecated
    public List<String> getSourceDirs() {
        return this.sources();
    }

    public ProjectDefinition addSources(String ... paths) {
        for (String path : paths) {
            this.appendProperty("sonar.sources", path);
        }
        return this;
    }

    @Deprecated
    public ProjectDefinition addSourceDirs(String ... paths) {
        return this.addSources(paths);
    }

    public ProjectDefinition addSources(File ... fileOrDirs) {
        for (File fileOrDir : fileOrDirs) {
            this.addSources(fileOrDir.getAbsolutePath());
        }
        return this;
    }

    @Deprecated
    public ProjectDefinition addSourceDirs(File ... dirs) {
        return this.addSources(dirs);
    }

    public ProjectDefinition resetSources() {
        this.properties.remove("sonar.sources");
        return this;
    }

    @Deprecated
    public ProjectDefinition resetSourceDirs() {
        return this.resetSources();
    }

    public ProjectDefinition setSources(String ... paths) {
        this.resetSources();
        return this.addSources(paths);
    }

    @Deprecated
    public ProjectDefinition setSourceDirs(String ... paths) {
        return this.setSources(paths);
    }

    public ProjectDefinition setSources(File ... filesOrDirs) {
        this.resetSources();
        for (File fileOrDir : filesOrDirs) {
            this.addSources(fileOrDir.getAbsolutePath());
        }
        return this;
    }

    @Deprecated
    public ProjectDefinition setSourceDirs(File ... dirs) {
        this.resetSourceDirs();
        for (File dir : dirs) {
            this.addSourceDirs(dir.getAbsolutePath());
        }
        return this;
    }

    @Deprecated
    public ProjectDefinition addSourceFiles(String ... paths) {
        List<String> sourceDirs = this.getSourceDirs();
        if (sourceDirs.size() == 1 && this.isDirectory(sourceDirs.get(0))) {
            this.resetSources();
        }
        return this.addSources(paths);
    }

    @Deprecated
    public ProjectDefinition addSourceFiles(File ... files) {
        List<String> sourceDirs = this.getSourceDirs();
        if (sourceDirs.size() == 1 && this.isDirectory(sourceDirs.get(0))) {
            this.resetSources();
        }
        return this.addSources(files);
    }

    @Deprecated
    public List<String> getSourceFiles() {
        return this.sources();
    }

    public List<String> tests() {
        String sources = (String)ObjectUtils.defaultIfNull((Object)this.properties.get("sonar.tests"), (Object)"");
        return ProjectDefinition.trim(StringUtils.split((String)sources, (char)','));
    }

    @Deprecated
    public List<String> getTestDirs() {
        return this.tests();
    }

    public ProjectDefinition addTests(String ... paths) {
        for (String path : paths) {
            this.appendProperty("sonar.tests", path);
        }
        return this;
    }

    @Deprecated
    public ProjectDefinition addTestDirs(String ... paths) {
        return this.addTests(paths);
    }

    public ProjectDefinition addTests(File ... fileOrDirs) {
        for (File fileOrDir : fileOrDirs) {
            this.addTests(fileOrDir.getAbsolutePath());
        }
        return this;
    }

    @Deprecated
    public ProjectDefinition addTestDirs(File ... dirs) {
        return this.addTests(dirs);
    }

    public ProjectDefinition setTests(String ... paths) {
        this.resetTests();
        return this.addTests(paths);
    }

    @Deprecated
    public ProjectDefinition setTestDirs(String ... paths) {
        return this.setTests(paths);
    }

    public ProjectDefinition setTests(File ... fileOrDirs) {
        this.resetTests();
        for (File dir : fileOrDirs) {
            this.addTests(dir.getAbsolutePath());
        }
        return this;
    }

    @Deprecated
    public ProjectDefinition setTestDirs(File ... dirs) {
        return this.setTests(dirs);
    }

    public ProjectDefinition resetTests() {
        this.properties.remove("sonar.tests");
        return this;
    }

    @Deprecated
    public ProjectDefinition resetTestDirs() {
        return this.resetTests();
    }

    @Deprecated
    public ProjectDefinition addTestFiles(String ... paths) {
        List<String> testDirs = this.getTestDirs();
        if (testDirs.size() == 1 && this.isDirectory(testDirs.get(0))) {
            this.resetTests();
        }
        return this.addTests(paths);
    }

    private boolean isDirectory(String relativeOrAbsoluteDir) {
        File file = new File(relativeOrAbsoluteDir);
        if (!file.isAbsolute()) {
            file = new File(this.baseDir, relativeOrAbsoluteDir);
        }
        return file.isDirectory();
    }

    @Deprecated
    public ProjectDefinition addTestFiles(File ... files) {
        List<String> testDirs = this.getTestDirs();
        if (testDirs.size() == 1 && this.isDirectory(testDirs.get(0))) {
            this.resetTests();
        }
        return this.addTests(files);
    }

    @Deprecated
    public List<String> getTestFiles() {
        return this.tests();
    }

    @Deprecated
    public List<String> getBinaries() {
        String sources = (String)ObjectUtils.defaultIfNull((Object)this.properties.get(BINARIES_PROPERTY), (Object)"");
        return ProjectDefinition.trim(StringUtils.split((String)sources, (char)','));
    }

    @Deprecated
    public ProjectDefinition addBinaryDir(String path) {
        this.appendProperty(BINARIES_PROPERTY, path);
        return this;
    }

    @Deprecated
    public ProjectDefinition addBinaryDir(File f) {
        return this.addBinaryDir(f.getAbsolutePath());
    }

    @Deprecated
    public List<String> getLibraries() {
        String sources = (String)ObjectUtils.defaultIfNull((Object)this.properties.get(LIBRARIES_PROPERTY), (Object)"");
        return ProjectDefinition.trim(StringUtils.split((String)sources, (char)','));
    }

    @Deprecated
    public void addLibrary(String path) {
        this.appendProperty(LIBRARIES_PROPERTY, path);
    }

    public ProjectDefinition addContainerExtension(Object extension) {
        this.containerExtensions.add(extension);
        return this;
    }

    public List<Object> getContainerExtensions() {
        return this.containerExtensions;
    }

    public ProjectDefinition addSubProject(ProjectDefinition child) {
        this.subProjects.add(child);
        child.setParent(this);
        return this;
    }

    public ProjectDefinition getParent() {
        return this.parent;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.subProjects.remove(this);
            this.parent = null;
            this.subProjects.clear();
        }
    }

    private void setParent(ProjectDefinition parent) {
        this.parent = parent;
    }

    public List<ProjectDefinition> getSubProjects() {
        return this.subProjects;
    }

    private static List<String> trim(String[] strings) {
        ArrayList result = Lists.newArrayList();
        for (String s : strings) {
            result.add(StringUtils.trim((String)s));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectDefinition that = (ProjectDefinition)o;
        String key = this.getKey();
        return !(key != null ? !key.equals(that.getKey()) : that.getKey() != null);
    }

    public int hashCode() {
        String key = this.getKey();
        return key != null ? key.hashCode() : 0;
    }
}

