/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.debt.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.debt.DebtCharacteristic;
import org.sonar.api.batch.debt.DebtModel;
import org.sonar.api.batch.debt.internal.DefaultDebtCharacteristic;

public class DefaultDebtModel
implements DebtModel {
    private Multimap<String, DebtCharacteristic> characteristicsByKey = ArrayListMultimap.create();

    public DefaultDebtModel addCharacteristic(DebtCharacteristic characteristic) {
        this.characteristicsByKey.put(null, (Object)characteristic);
        return this;
    }

    public DefaultDebtModel addSubCharacteristic(DebtCharacteristic subCharacteristic, String characteristicKey) {
        this.characteristicsByKey.put((Object)characteristicKey, (Object)subCharacteristic);
        return this;
    }

    @Override
    public List<DebtCharacteristic> characteristics() {
        return Lists.newArrayList((Iterable)this.characteristicsByKey.get(null));
    }

    @Override
    public List<DebtCharacteristic> subCharacteristics(String characteristicKey) {
        return Lists.newArrayList((Iterable)this.characteristicsByKey.get((Object)characteristicKey));
    }

    @Override
    public List<DebtCharacteristic> allCharacteristics() {
        return Lists.newArrayList((Iterable)this.characteristicsByKey.values());
    }

    @Override
    @CheckForNull
    public DebtCharacteristic characteristicByKey(final String key) {
        return (DebtCharacteristic)Iterables.find((Iterable)this.characteristicsByKey.values(), (Predicate)new Predicate<DebtCharacteristic>(){

            public boolean apply(DebtCharacteristic input) {
                return key.equals(input.key());
            }
        }, null);
    }

    @CheckForNull
    public DebtCharacteristic characteristicById(final int id) {
        return (DebtCharacteristic)Iterables.find((Iterable)this.characteristicsByKey.values(), (Predicate)new Predicate<DebtCharacteristic>(){

            public boolean apply(DebtCharacteristic input) {
                return id == ((DefaultDebtCharacteristic)input).id();
            }
        }, null);
    }
}

