/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.nio.file.Path;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.utils.PathUtils;

public class DefaultInputDir
implements InputDir {
    private final String relativePath;
    private final String moduleKey;
    private Path moduleBaseDir;

    public DefaultInputDir(String moduleKey, String relativePath) {
        this.moduleKey = moduleKey;
        this.relativePath = PathUtils.sanitize(relativePath);
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    public String absolutePath() {
        return PathUtils.sanitize(this.path().toString());
    }

    @Override
    public File file() {
        return this.path().toFile();
    }

    @Override
    public Path path() {
        if (this.moduleBaseDir == null) {
            throw new IllegalStateException("Can not return the java.nio.file.Path because module baseDir is not set (see method setModuleBaseDir(java.io.File))");
        }
        return this.moduleBaseDir.resolve(this.relativePath);
    }

    public String moduleKey() {
        return this.moduleKey;
    }

    public String key() {
        return this.moduleKey + ":" + this.relativePath;
    }

    public DefaultInputDir setModuleBaseDir(Path moduleBaseDir) {
        this.moduleBaseDir = moduleBaseDir.normalize();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultInputDir that = (DefaultInputDir)o;
        return this.moduleKey.equals(that.moduleKey) && this.relativePath.equals(that.relativePath);
    }

    public int hashCode() {
        return this.moduleKey.hashCode() + this.relativePath.hashCode() * 13;
    }

    public String toString() {
        return "[moduleKey=" + this.moduleKey + ", relative=" + this.relativePath + ", basedir=" + this.moduleBaseDir + "]";
    }
}

