/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.PathUtils;

public class DefaultInputFile
implements InputFile {
    private final String relativePath;
    private final String moduleKey;
    protected Path moduleBaseDir;
    private String language;
    private InputFile.Type type = InputFile.Type.MAIN;
    private InputFile.Status status;
    private int lines;
    private Charset charset;
    private int lastValidOffset;

    public DefaultInputFile(String moduleKey, String relativePath) {
        this.moduleKey = moduleKey;
        this.relativePath = PathUtils.sanitize(relativePath);
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    public String absolutePath() {
        return PathUtils.sanitize(this.path().toString());
    }

    @Override
    public File file() {
        return this.path().toFile();
    }

    @Override
    public Path path() {
        if (this.moduleBaseDir == null) {
            throw new IllegalStateException("Can not return the java.nio.file.Path because module baseDir is not set (see method setModuleBaseDir(java.io.File))");
        }
        return this.moduleBaseDir.resolve(this.relativePath);
    }

    @Override
    @CheckForNull
    public String language() {
        return this.language;
    }

    @Override
    public InputFile.Type type() {
        return this.type;
    }

    @Override
    public InputFile.Status status() {
        return this.status;
    }

    @Override
    public int lines() {
        return this.lines;
    }

    public String key() {
        return this.moduleKey + ":" + this.relativePath;
    }

    public String moduleKey() {
        return this.moduleKey;
    }

    public Charset charset() {
        return this.charset;
    }

    public DefaultInputFile setModuleBaseDir(Path moduleBaseDir) {
        this.moduleBaseDir = moduleBaseDir.normalize();
        return this;
    }

    public DefaultInputFile setLanguage(@Nullable String language) {
        this.language = language;
        return this;
    }

    public DefaultInputFile setType(InputFile.Type type) {
        this.type = type;
        return this;
    }

    public DefaultInputFile setStatus(InputFile.Status status) {
        this.status = status;
        return this;
    }

    public DefaultInputFile setLines(int lines) {
        this.lines = lines;
        return this;
    }

    public DefaultInputFile setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public int lastValidOffset() {
        return this.lastValidOffset;
    }

    public DefaultInputFile setLastValidOffset(int lastValidOffset) {
        this.lastValidOffset = lastValidOffset;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultInputFile)) {
            return false;
        }
        DefaultInputFile that = (DefaultInputFile)o;
        return this.moduleKey.equals(that.moduleKey) && this.relativePath.equals(that.relativePath);
    }

    public int hashCode() {
        return this.moduleKey.hashCode() + this.relativePath.hashCode() * 13;
    }

    public String toString() {
        return "[moduleKey=" + this.moduleKey + ", relative=" + this.relativePath + ", basedir=" + this.moduleBaseDir + "]";
    }
}

