/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.WildcardPattern;

public abstract class PathPattern {
    final WildcardPattern pattern;

    PathPattern(String pattern) {
        this.pattern = WildcardPattern.create(pattern);
    }

    public abstract boolean match(InputFile var1);

    public abstract boolean match(InputFile var1, boolean var2);

    public static PathPattern create(String s) {
        String trimmed = StringUtils.trim((String)s);
        if (StringUtils.startsWithIgnoreCase((String)trimmed, (String)"file:")) {
            return new AbsolutePathPattern(StringUtils.substring((String)trimmed, (int)"file:".length()));
        }
        return new RelativePathPattern(trimmed);
    }

    public static PathPattern[] create(String[] s) {
        PathPattern[] result = new PathPattern[s.length];
        for (int i = 0; i < s.length; ++i) {
            result[i] = PathPattern.create(s[i]);
        }
        return result;
    }

    static String sanitizeExtension(String suffix) {
        return StringUtils.lowerCase((String)StringUtils.removeStart((String)suffix, (String)"."));
    }

    private static class RelativePathPattern
    extends PathPattern {
        private RelativePathPattern(String pattern) {
            super(pattern);
        }

        @Override
        public boolean match(InputFile inputFile) {
            return this.match(inputFile, true);
        }

        @Override
        public boolean match(InputFile inputFile, boolean caseSensitiveFileExtension) {
            String extension;
            String path = inputFile.relativePath();
            if (!caseSensitiveFileExtension && StringUtils.isNotBlank((String)(extension = PathPattern.sanitizeExtension(FilenameUtils.getExtension((String)inputFile.file().getName()))))) {
                path = StringUtils.removeEndIgnoreCase((String)path, (String)extension);
                path = path + extension;
            }
            return path != null && this.pattern.match(path);
        }

        public String toString() {
            return this.pattern.toString();
        }
    }

    private static class AbsolutePathPattern
    extends PathPattern {
        private AbsolutePathPattern(String pattern) {
            super(pattern);
        }

        @Override
        public boolean match(InputFile inputFile) {
            return this.match(inputFile, true);
        }

        @Override
        public boolean match(InputFile inputFile, boolean caseSensitiveFileExtension) {
            String extension;
            String path = inputFile.absolutePath();
            if (!caseSensitiveFileExtension && StringUtils.isNotBlank((String)(extension = PathPattern.sanitizeExtension(FilenameUtils.getExtension((String)inputFile.file().getName()))))) {
                path = StringUtils.removeEndIgnoreCase((String)path, (String)extension);
                path = path + extension;
            }
            return this.pattern.match(path);
        }

        public String toString() {
            return "file:" + this.pattern.toString();
        }
    }
}

