/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.dependency.internal;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.dependency.Dependency;
import org.sonar.api.batch.sensor.dependency.NewDependency;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;

public class DefaultDependency
extends DefaultStorable
implements Dependency,
NewDependency {
    private String fromKey;
    private String toKey;
    private int weight = 1;

    public DefaultDependency() {
        super(null);
    }

    public DefaultDependency(@Nullable SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultDependency from(InputFile from) {
        Preconditions.checkNotNull((Object)from, (Object)"InputFile should be non null");
        this.fromKey = ((DefaultInputFile)from).key();
        return this;
    }

    @Override
    public DefaultDependency to(InputFile to) {
        Preconditions.checkNotNull((Object)to, (Object)"InputFile should be non null");
        this.toKey = ((DefaultInputFile)to).key();
        return this;
    }

    @Override
    public DefaultDependency weight(int weight) {
        Preconditions.checkArgument((weight > 1 ? 1 : 0) != 0, (Object)"weight should be greater than 1");
        this.weight = weight;
        return this;
    }

    @Override
    public void doSave() {
        Preconditions.checkState((!this.fromKey.equals(this.toKey) ? 1 : 0) != 0, (Object)"From and To can't be the same inputFile");
        Preconditions.checkNotNull((Object)this.fromKey, (Object)"From inputFile can't be null");
        Preconditions.checkNotNull((Object)this.toKey, (Object)"To inputFile can't be null");
        this.storage.store(this);
    }

    @Override
    public String fromKey() {
        return this.fromKey;
    }

    public DefaultDependency setFromKey(String fromKey) {
        this.fromKey = fromKey;
        return this;
    }

    @Override
    public String toKey() {
        return this.toKey;
    }

    public DefaultDependency setToKey(String toKey) {
        this.toKey = toKey;
        return this;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    public DefaultDependency setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultDependency rhs = (DefaultDependency)obj;
        return new EqualsBuilder().append((Object)this.fromKey, (Object)rhs.fromKey).append((Object)this.toKey, (Object)rhs.toKey).append(this.weight, rhs.weight).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(27, 45).append((Object)this.fromKey).append((Object)this.toKey).append(this.weight).toHashCode();
    }
}

