/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.duplication;

import com.google.common.annotations.Beta;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@Beta
public interface Duplication {
    public Block originBlock();

    public List<Block> duplicates();

    public static class Block {
        private final String resourceKey;
        private final int startLine;
        private final int length;

        public Block(String resourceKey, int startLine, int length) {
            this.resourceKey = resourceKey;
            this.startLine = startLine;
            this.length = length;
        }

        public String resourceKey() {
            return this.resourceKey;
        }

        public int startLine() {
            return this.startLine;
        }

        public int length() {
            return this.length;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Block rhs = (Block)obj;
            return new EqualsBuilder().append((Object)this.resourceKey, (Object)rhs.resourceKey).append(this.startLine, rhs.startLine).append(this.length, rhs.length).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(13, 43).append((Object)this.resourceKey).append(this.startLine).append(this.length).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("resourceKey", (Object)this.resourceKey).append("startLine", this.startLine).append("length", this.length).toString();
        }
    }
}

