/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.highlighting.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.highlighting.internal.SyntaxHighlightingRule;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;

public class DefaultHighlighting
extends DefaultStorable
implements NewHighlighting {
    private InputFile inputFile;
    private Set<SyntaxHighlightingRule> syntaxHighlightingRuleSet = Sets.newTreeSet((Comparator)new Comparator<SyntaxHighlightingRule>(){

        @Override
        public int compare(SyntaxHighlightingRule left, SyntaxHighlightingRule right) {
            int result = left.getStartPosition() - right.getStartPosition();
            if (result == 0) {
                result = right.getEndPosition() - left.getEndPosition();
            }
            return result;
        }
    });

    public DefaultHighlighting() {
        this(null);
    }

    public DefaultHighlighting(@Nullable SensorStorage storage) {
        super(storage);
    }

    public Set<SyntaxHighlightingRule> getSyntaxHighlightingRuleSet() {
        return this.syntaxHighlightingRuleSet;
    }

    private void checkOverlappingBoudaries() {
        if (this.syntaxHighlightingRuleSet.size() > 1) {
            Iterator<SyntaxHighlightingRule> it = this.syntaxHighlightingRuleSet.iterator();
            SyntaxHighlightingRule previous = it.next();
            while (it.hasNext()) {
                SyntaxHighlightingRule current = it.next();
                if (previous.getEndPosition() > current.getStartPosition() && previous.getEndPosition() < current.getEndPosition()) {
                    String errorMsg = String.format("Cannot register highlighting rule for characters from %s to %s as it overlaps at least one existing rule", current.getStartPosition(), current.getEndPosition());
                    throw new IllegalStateException(errorMsg);
                }
                previous = current;
            }
        }
    }

    @Override
    public DefaultHighlighting onFile(InputFile inputFile) {
        Preconditions.checkNotNull((Object)inputFile, (Object)"file can't be null");
        this.inputFile = inputFile;
        return this;
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    @Override
    public DefaultHighlighting highlight(int startOffset, int endOffset, TypeOfText typeOfText) {
        Preconditions.checkState((this.inputFile != null ? 1 : 0) != 0, (Object)"Call onFile() first");
        int maxValidOffset = ((DefaultInputFile)this.inputFile).lastValidOffset();
        this.checkOffset(startOffset, maxValidOffset, "startOffset");
        this.checkOffset(endOffset, maxValidOffset, "endOffset");
        Preconditions.checkArgument((startOffset < endOffset ? 1 : 0) != 0, (Object)("startOffset (" + startOffset + ") should be < endOffset (" + endOffset + ") for file " + this.inputFile + "."));
        SyntaxHighlightingRule syntaxHighlightingRule = SyntaxHighlightingRule.create(startOffset, endOffset, typeOfText);
        this.syntaxHighlightingRuleSet.add(syntaxHighlightingRule);
        return this;
    }

    private void checkOffset(int offset, int maxValidOffset, String label) {
        Preconditions.checkArgument((offset >= 0 && offset <= maxValidOffset ? 1 : 0) != 0, (Object)("Invalid " + label + " " + offset + ". Should be >= 0 and <= " + maxValidOffset + " for file " + this.inputFile));
    }

    @Override
    protected void doSave() {
        Preconditions.checkState((this.inputFile != null ? 1 : 0) != 0, (Object)"Call onFile() first");
        this.checkOverlappingBoudaries();
        this.storage.store(this);
    }
}

