/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import com.google.common.annotations.Beta;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.DefaultInputDir;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.dependency.Dependency;
import org.sonar.api.batch.sensor.dependency.NewDependency;
import org.sonar.api.batch.sensor.dependency.internal.DefaultDependency;
import org.sonar.api.batch.sensor.duplication.Duplication;
import org.sonar.api.batch.sensor.duplication.NewDuplication;
import org.sonar.api.batch.sensor.duplication.internal.DefaultDuplication;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.highlighting.internal.SyntaxHighlightingRule;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssue;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.measure.NewMeasure;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.Metric;

@Beta
public class SensorContextTester
implements SensorContext {
    private Settings settings = new Settings();
    private DefaultFileSystem fs;
    private ActiveRules activeRules;
    private MockAnalysisMode analysisMode;
    private InMemorySensorStorage sensorStorage;

    private SensorContextTester(File moduleBaseDir) {
        this.fs = new DefaultFileSystem(moduleBaseDir);
        this.activeRules = new ActiveRulesBuilder().build();
        this.analysisMode = new MockAnalysisMode();
        this.sensorStorage = new InMemorySensorStorage();
    }

    public static SensorContextTester create(File moduleBaseDir) {
        return new SensorContextTester(moduleBaseDir);
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public DefaultFileSystem fileSystem() {
        return this.fs;
    }

    public void setFileSystem(DefaultFileSystem fs) {
        this.fs = fs;
    }

    @Override
    public ActiveRules activeRules() {
        return this.activeRules;
    }

    public void setActiveRules(ActiveRules activeRules) {
        this.activeRules = activeRules;
    }

    @Override
    public MockAnalysisMode analysisMode() {
        return this.analysisMode;
    }

    @Override
    public <G extends Serializable> NewMeasure<G> newMeasure() {
        return new DefaultMeasure(this.sensorStorage);
    }

    public Collection<Measure> measures(@Nullable String componetKey) {
        if (componetKey == null) {
            return this.sensorStorage.projectMeasuresByMetric.values();
        }
        Map measures = (Map)this.sensorStorage.measuresByComponentAndMetric.get(componetKey);
        return measures != null ? measures.values() : Collections.emptyList();
    }

    public <G extends Serializable> Measure<G> measure(String componetKey, Metric<G> metric) {
        return this.measure(componetKey, metric.key());
    }

    public Measure measure(String componetKey, String metricKey) {
        if (componetKey == null) {
            return (Measure)this.sensorStorage.projectMeasuresByMetric.get(metricKey);
        }
        Map measures = (Map)this.sensorStorage.measuresByComponentAndMetric.get(componetKey);
        return measures != null ? (Measure)measures.get(metricKey) : null;
    }

    @Override
    public NewIssue newIssue() {
        return new DefaultIssue(this.sensorStorage);
    }

    public Collection<Issue> allIssues() {
        ArrayList<Issue> result = new ArrayList<Issue>();
        result.addAll(this.sensorStorage.projectIssues);
        for (String key : this.sensorStorage.issuesByComponent.keySet()) {
            result.addAll((Collection)this.sensorStorage.issuesByComponent.get(key));
        }
        return result;
    }

    public Collection<Issue> issues(@Nullable String componentKey) {
        if (componentKey != null) {
            List<Issue> list = (List<Issue>)this.sensorStorage.issuesByComponent.get(componentKey);
            return list != null ? list : Collections.emptyList();
        }
        return this.sensorStorage.projectIssues;
    }

    @Override
    public NewHighlighting newHighlighting() {
        return new DefaultHighlighting(this.sensorStorage);
    }

    public List<TypeOfText> highlightingTypeFor(String componentKey, int charIndex) {
        DefaultHighlighting syntaxHighlightingData = (DefaultHighlighting)this.sensorStorage.highlightingByComponent.get(componentKey);
        if (syntaxHighlightingData == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeOfText> result = new ArrayList<TypeOfText>();
        for (SyntaxHighlightingRule sortedRule : syntaxHighlightingData.getSyntaxHighlightingRuleSet()) {
            if (sortedRule.getStartPosition() > charIndex || sortedRule.getEndPosition() <= charIndex) continue;
            result.add(sortedRule.getTextType());
        }
        return result;
    }

    @Override
    public NewDuplication newDuplication() {
        return new DefaultDuplication(this.sensorStorage);
    }

    public Collection<Duplication> duplications() {
        return this.sensorStorage.duplications;
    }

    @Override
    public NewDependency newDependency() {
        return new DefaultDependency(this.sensorStorage);
    }

    public Collection<Dependency> dependencies() {
        return this.sensorStorage.dependencies;
    }

    private static class InMemorySensorStorage
    implements SensorStorage {
        private Map<String, Measure> projectMeasuresByMetric = new HashMap<String, Measure>();
        private Map<String, Map<String, Measure>> measuresByComponentAndMetric = new HashMap<String, Map<String, Measure>>();
        private Collection<Issue> projectIssues = new ArrayList<Issue>();
        private Map<String, List<Issue>> issuesByComponent = new HashMap<String, List<Issue>>();
        private Map<String, DefaultHighlighting> highlightingByComponent = new HashMap<String, DefaultHighlighting>();
        private List<Duplication> duplications = new ArrayList<Duplication>();
        private List<Dependency> dependencies = new ArrayList<Dependency>();

        private InMemorySensorStorage() {
        }

        @Override
        public void store(Measure measure) {
            String key = this.getKey(measure.inputFile());
            if (key == null) {
                this.projectMeasuresByMetric.put(measure.metric().key(), measure);
            } else {
                if (!this.measuresByComponentAndMetric.containsKey(key)) {
                    this.measuresByComponentAndMetric.put(key, new HashMap());
                }
                this.measuresByComponentAndMetric.get(key).put(measure.metric().key(), measure);
            }
        }

        @Override
        public void store(Issue issue) {
            String key = this.getKey(issue.inputPath());
            if (key == null) {
                this.projectIssues.add(issue);
            } else {
                if (!this.issuesByComponent.containsKey(key)) {
                    this.issuesByComponent.put(key, new ArrayList());
                }
                this.issuesByComponent.get(key).add(issue);
            }
        }

        @Override
        public void store(Duplication duplication) {
            this.duplications.add(duplication);
        }

        @Override
        public void store(Dependency dependency) {
            this.dependencies.add(dependency);
        }

        @Override
        public void store(DefaultHighlighting highlighting) {
            this.highlightingByComponent.put(this.getKey(highlighting.inputFile()), highlighting);
        }

        @CheckForNull
        private String getKey(@Nullable InputPath inputPath) {
            if (inputPath == null) {
                return null;
            }
            if (inputPath instanceof InputFile) {
                return ((DefaultInputFile)inputPath).key();
            }
            if (inputPath instanceof InputDir) {
                return ((DefaultInputDir)inputPath).key();
            }
            throw new IllegalStateException("Unknow component " + inputPath);
        }
    }

    public static class MockAnalysisMode
    implements AnalysisMode {
        private boolean isIncremental = false;
        private boolean isPreview = false;

        @Override
        public boolean isIncremental() {
            return this.isIncremental;
        }

        public void setIncremental(boolean value) {
            this.isIncremental = value;
        }

        @Override
        public boolean isPreview() {
            return this.isPreview;
        }

        public void setPreview(boolean value) {
            this.isPreview = value;
        }
    }
}

