/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.measure.internal;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.measure.NewMeasure;

public class DefaultMeasure<G extends Serializable>
extends DefaultStorable
implements Measure<G>,
NewMeasure<G> {
    private boolean onProject = false;
    private InputFile file;
    private Metric<G> metric;
    private G value;
    private boolean fromCore = false;

    public DefaultMeasure() {
    }

    public DefaultMeasure(@Nullable SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultMeasure<G> onFile(InputFile inputFile) {
        Preconditions.checkState((!this.onProject ? 1 : 0) != 0, (Object)"onProject already called");
        Preconditions.checkState((this.file == null ? 1 : 0) != 0, (Object)"onFile already called");
        Preconditions.checkNotNull((Object)inputFile, (Object)"InputFile should be non null");
        this.file = inputFile;
        return this;
    }

    @Override
    public DefaultMeasure<G> onProject() {
        Preconditions.checkState((!this.onProject ? 1 : 0) != 0, (Object)"onProject already called");
        Preconditions.checkState((this.file == null ? 1 : 0) != 0, (Object)"onFile already called");
        this.onProject = true;
        return this;
    }

    @Override
    public DefaultMeasure<G> forMetric(Metric<G> metric) {
        Preconditions.checkState((metric != null ? 1 : 0) != 0, (Object)"Metric already defined");
        Preconditions.checkNotNull(metric, (Object)"metric should be non null");
        this.metric = metric;
        return this;
    }

    @Override
    public DefaultMeasure<G> withValue(G value) {
        Preconditions.checkState((this.value == null ? 1 : 0) != 0, (Object)"Measure value already defined");
        Preconditions.checkNotNull(value, (Object)"Measure value can't be null");
        this.value = value;
        return this;
    }

    public boolean isFromCore() {
        return this.fromCore;
    }

    public DefaultMeasure<G> setFromCore() {
        this.fromCore = true;
        return this;
    }

    @Override
    public void doSave() {
        Preconditions.checkNotNull(this.value, (Object)"Measure value can't be null");
        Preconditions.checkNotNull(this.metric, (Object)"Measure metric can't be null");
        Preconditions.checkState((boolean)this.metric.valueType().equals(this.value.getClass()), (Object)("Measure value should be of type " + this.metric.valueType()));
        this.storage.store(this);
    }

    @Override
    public Metric<G> metric() {
        return this.metric;
    }

    @Override
    @CheckForNull
    public InputFile inputFile() {
        return this.file;
    }

    @Override
    public G value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultMeasure rhs = (DefaultMeasure)obj;
        return new EqualsBuilder().append((Object)this.file, (Object)rhs.file).append(this.metric, rhs.metric).append(this.value, rhs.value).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(27, 45).append((Object)this.file).append(this.metric).append(this.value).toHashCode();
    }
}

