/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.SecureRandom;
import javax.annotation.Nullable;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Cipher;

final class AesCipher
extends Cipher {
    public static final int KEY_SIZE_IN_BITS = 128;
    private static final String CRYPTO_KEY = "AES";
    private String pathToSecretKey;

    AesCipher(@Nullable String pathToSecretKey) {
        this.pathToSecretKey = pathToSecretKey;
    }

    @Override
    String encrypt(String clearText) {
        try {
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(CRYPTO_KEY);
            cipher.init(1, this.loadSecretFile());
            return Base64.encodeBase64String((byte[])cipher.doFinal(clearText.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    String decrypt(String encryptedText) {
        try {
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(CRYPTO_KEY);
            cipher.init(2, this.loadSecretFile());
            byte[] cipherData = cipher.doFinal(Base64.decodeBase64((String)StringUtils.trim((String)encryptedText)));
            return new String(cipherData, Charsets.UTF_8);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    boolean hasSecretKey() {
        String path = this.getPathToSecretKey();
        if (StringUtils.isNotBlank((String)path)) {
            File file = new File(path);
            return file.exists() && file.isFile();
        }
        return false;
    }

    private Key loadSecretFile() throws IOException {
        String path = this.getPathToSecretKey();
        return this.loadSecretFileFromFile(path);
    }

    @VisibleForTesting
    Key loadSecretFileFromFile(@Nullable String path) throws IOException {
        if (StringUtils.isBlank((String)path)) {
            throw new IllegalStateException("Secret key not found. Please set the property sonar.secretKeyPath");
        }
        File file = new File(path);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalStateException("The property sonar.secretKeyPath does not link to a valid file: " + path);
        }
        String s = FileUtils.readFileToString((File)file);
        if (StringUtils.isBlank((String)s)) {
            throw new IllegalStateException("No secret key in the file: " + path);
        }
        return new SecretKeySpec(Base64.decodeBase64((String)StringUtils.trim((String)s)), CRYPTO_KEY);
    }

    String generateRandomSecretKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(CRYPTO_KEY);
            keyGen.init(128, new SecureRandom());
            SecretKey secretKey = keyGen.generateKey();
            return Base64.encodeBase64String((byte[])secretKey.getEncoded());
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to generate secret key", e);
        }
    }

    @VisibleForTesting
    String getPathToSecretKey() {
        if (StringUtils.isBlank((String)this.pathToSecretKey)) {
            this.pathToSecretKey = new File(FileUtils.getUserDirectoryPath(), ".sonar/sonar-secret.txt").getPath();
        }
        return this.pathToSecretKey;
    }

    public void setPathToSecretKey(@Nullable String pathToSecretKey) {
        this.pathToSecretKey = pathToSecretKey;
    }
}

