/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.database.model;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import java.io.UnsupportedEncodingException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.measures.Metric;
import org.sonar.api.rules.RulePriority;

@Entity
@Table(name="project_measures")
public class MeasureModel
implements Cloneable {
    public static final int TEXT_VALUE_LENGTH = 4000;
    @Id
    @Column(name="id")
    @GeneratedValue
    private Long id;
    @Column(name="value", updatable=true, nullable=true, precision=30, scale=20)
    private Double value = 0.0;
    @Column(name="text_value", updatable=true, nullable=true, length=4000)
    private String textValue;
    @Column(name="tendency", updatable=true, nullable=true)
    private Integer tendency;
    @Column(name="metric_id", updatable=false, nullable=false)
    private Integer metricId;
    @Column(name="snapshot_id", updatable=true, nullable=true)
    private Integer snapshotId;
    @Column(name="project_id", updatable=true, nullable=true)
    private Integer projectId;
    @Column(name="description", updatable=true, nullable=true, length=4000)
    private String description;
    @Column(name="rule_id", updatable=true, nullable=true)
    private Integer ruleId;
    @Column(name="rule_priority", updatable=false, nullable=true)
    @Enumerated(value=EnumType.ORDINAL)
    private RulePriority rulePriority;
    @Column(name="alert_status", updatable=true, nullable=true, length=5)
    private String alertStatus;
    @Column(name="alert_text", updatable=true, nullable=true, length=4000)
    private String alertText;
    @Column(name="variation_value_1", updatable=true, nullable=true)
    private Double variationValue1;
    @Column(name="variation_value_2", updatable=true, nullable=true)
    private Double variationValue2;
    @Column(name="variation_value_3", updatable=true, nullable=true)
    private Double variationValue3;
    @Column(name="variation_value_4", updatable=true, nullable=true)
    private Double variationValue4;
    @Column(name="variation_value_5", updatable=true, nullable=true)
    private Double variationValue5;
    @Column(name="url", updatable=true, nullable=true, length=2000)
    private String url;
    @Column(name="characteristic_id", nullable=true)
    private Integer characteristicId;
    @Column(name="person_id", updatable=true, nullable=true)
    private Integer personId;
    @Column(name="measure_data", updatable=true, nullable=true, length=0x9FFFFF6)
    private byte[] data;

    public MeasureModel(int metricId, Double val) {
        if (val.isNaN() || val.isInfinite()) {
            throw new IllegalArgumentException("Measure value is NaN. Metric=" + metricId);
        }
        this.metricId = metricId;
        this.value = val;
    }

    public MeasureModel(int metricId, Metric.Level level) {
        this.metricId = metricId;
        if (level != null) {
            this.textValue = level.toString();
        }
    }

    public MeasureModel(int metricId, String val) {
        this.metricId = metricId;
        this.setData(val);
    }

    public MeasureModel() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Double getValue() {
        return this.value;
    }

    public MeasureModel setValue(Double value) {
        if (value != null && (value.isNaN() || value.isInfinite())) {
            throw new IllegalArgumentException();
        }
        this.value = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Metric.Level getLevelValue() {
        if (this.textValue != null) {
            return Metric.Level.valueOf(this.textValue);
        }
        return null;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public Integer getTendency() {
        return this.tendency;
    }

    public MeasureModel setTendency(Integer tendency) {
        this.tendency = tendency;
        return this;
    }

    public boolean isRuleMeasure() {
        return this.ruleId != null || this.rulePriority != null;
    }

    public Integer getMetricId() {
        return this.metricId;
    }

    public void setMetricId(Integer metricId) {
        this.metricId = metricId;
    }

    public Integer getSnapshotId() {
        return this.snapshotId;
    }

    public MeasureModel setSnapshotId(Integer snapshotId) {
        this.snapshotId = snapshotId;
        return this;
    }

    public Integer getRuleId() {
        return this.ruleId;
    }

    public MeasureModel setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public RulePriority getRulePriority() {
        return this.rulePriority;
    }

    public void setRulePriority(RulePriority rulePriority) {
        this.rulePriority = rulePriority;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public Metric.Level getAlertStatus() {
        if (this.alertStatus == null) {
            return null;
        }
        return Metric.Level.valueOf(this.alertStatus);
    }

    public MeasureModel setAlertStatus(Metric.Level level) {
        this.alertStatus = level != null ? level.toString() : null;
        return this;
    }

    public String getData(Metric metric) {
        if (this.textValue != null) {
            return this.textValue;
        }
        if (metric.isDataType() && this.data != null) {
            try {
                return new String(this.data, Charsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    public final void setData(String data) {
        if (data == null) {
            this.textValue = null;
            this.data = null;
        } else if (data.length() > 4000) {
            this.textValue = null;
            this.data = data.getBytes(Charsets.UTF_8);
        } else {
            this.textValue = data;
            this.data = null;
        }
    }

    public String getAlertText() {
        return this.alertText;
    }

    public void setAlertText(String alertText) {
        this.alertText = alertText;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }

    public Double getVariationValue1() {
        return this.variationValue1;
    }

    public void setVariationValue1(Double d) {
        this.variationValue1 = d;
    }

    public Double getVariationValue2() {
        return this.variationValue2;
    }

    public void setVariationValue2(Double d) {
        this.variationValue2 = d;
    }

    public Double getVariationValue3() {
        return this.variationValue3;
    }

    public void setVariationValue3(Double d) {
        this.variationValue3 = d;
    }

    public Double getVariationValue4() {
        return this.variationValue4;
    }

    public void setVariationValue4(Double d) {
        this.variationValue4 = d;
    }

    public Double getVariationValue5() {
        return this.variationValue5;
    }

    public void setVariationValue5(Double d) {
        this.variationValue5 = d;
    }

    public MeasureModel save(DatabaseSession session) {
        session.save(this);
        return this;
    }

    public Integer getCharacteristicId() {
        return this.characteristicId;
    }

    public MeasureModel setCharacteristicId(Integer characteristicId) {
        this.characteristicId = characteristicId;
        return this;
    }

    public Integer getPersonId() {
        return this.personId;
    }

    public MeasureModel setPersonId(Integer i) {
        this.personId = i;
        return this;
    }

    public Object clone() {
        MeasureModel clone = new MeasureModel();
        clone.setMetricId(this.getMetricId());
        clone.setDescription(this.getDescription());
        clone.setTextValue(this.getTextValue());
        clone.setAlertStatus(this.getAlertStatus());
        clone.setAlertText(this.getAlertText());
        clone.setTendency(this.getTendency());
        clone.setVariationValue1(this.getVariationValue1());
        clone.setVariationValue2(this.getVariationValue2());
        clone.setVariationValue3(this.getVariationValue3());
        clone.setVariationValue4(this.getVariationValue4());
        clone.setVariationValue5(this.getVariationValue5());
        clone.setValue(this.getValue());
        clone.setRulePriority(this.getRulePriority());
        clone.setRuleId(this.getRuleId());
        clone.setSnapshotId(this.getSnapshotId());
        clone.setUrl(this.getUrl());
        clone.setCharacteristicId(this.getCharacteristicId());
        clone.setPersonId(this.getPersonId());
        return clone;
    }
}

