/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue.internal;

import java.io.Serializable;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.issue.IssueComment;
import org.sonar.api.utils.internal.Uuids;

public class DefaultIssueComment
implements Serializable,
IssueComment {
    private String issueKey;
    private String userLogin;
    private Date createdAt;
    private Date updatedAt;
    private String key;
    private String markdownText;
    private boolean isNew;

    public static DefaultIssueComment create(String issueKey, @Nullable String login, String markdownText) {
        DefaultIssueComment comment = new DefaultIssueComment();
        comment.setIssueKey(issueKey);
        comment.setKey(Uuids.create());
        Date now = new Date();
        comment.setUserLogin(login);
        comment.setMarkdownText(markdownText);
        comment.setCreatedAt(now).setUpdatedAt(now);
        comment.setNew(true);
        return comment;
    }

    @Override
    public String markdownText() {
        return this.markdownText;
    }

    public DefaultIssueComment setMarkdownText(String s) {
        this.markdownText = s;
        return this;
    }

    @Override
    public String issueKey() {
        return this.issueKey;
    }

    public DefaultIssueComment setIssueKey(String s) {
        this.issueKey = s;
        return this;
    }

    @Override
    public String key() {
        return this.key;
    }

    public DefaultIssueComment setKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    @CheckForNull
    public String userLogin() {
        return this.userLogin;
    }

    public DefaultIssueComment setUserLogin(@Nullable String userLogin) {
        this.userLogin = userLogin;
        return this;
    }

    @Override
    public Date createdAt() {
        return this.createdAt;
    }

    public DefaultIssueComment setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Override
    public Date updatedAt() {
        return this.updatedAt;
    }

    public DefaultIssueComment setUpdatedAt(@Nullable Date updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public DefaultIssueComment setNew(boolean b) {
        this.isNew = b;
        return this;
    }
}

