/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.platform;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.api.utils.internal.Uuids;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

class ComponentKeys {
    private static final Pattern IDENTITY_HASH_PATTERN = Pattern.compile(".+@[a-f0-9]+");
    private final Set<Class> objectsWithoutToString = new HashSet<Class>();

    ComponentKeys() {
    }

    Object of(Object component) {
        return this.of(component, Loggers.get(ComponentKeys.class));
    }

    @VisibleForTesting
    Object of(Object component, Logger log) {
        if (component instanceof Class) {
            return component;
        }
        String key = component.toString();
        if (IDENTITY_HASH_PATTERN.matcher(key).matches()) {
            if (!this.objectsWithoutToString.add(component.getClass())) {
                log.warn(String.format("Bad component key: %s. Please implement toString() method on class %s", key, component.getClass().getName()));
            }
            key = key + Uuids.create();
        }
        return component.getClass().getCanonicalName() + "-" + key;
    }
}

