/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.io.File;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.WildcardPattern;

public class Directory
extends Resource {
    public static final String SEPARATOR = "/";
    public static final String ROOT = "[root]";
    private final String relativePathFromSourceDir;

    Directory() {
        this.relativePathFromSourceDir = null;
    }

    @Deprecated
    public Directory(String relativePathFromSourceDir) {
        this(relativePathFromSourceDir, null);
    }

    @Deprecated
    public Directory(String relativePathFromSourceDir, Language language) {
        this.relativePathFromSourceDir = Directory.parseKey(relativePathFromSourceDir);
    }

    public String relativePathFromSourceDir() {
        return this.relativePathFromSourceDir;
    }

    @Override
    public String getName() {
        return this.getKey();
    }

    @Override
    public String getLongName() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Language getLanguage() {
        return null;
    }

    @Override
    public String getScope() {
        return "DIR";
    }

    @Override
    public String getQualifier() {
        return "DIR";
    }

    @Override
    public Resource getParent() {
        return null;
    }

    @Override
    public boolean matchFilePattern(String antPattern) {
        WildcardPattern matcher = WildcardPattern.create(antPattern, SEPARATOR);
        return matcher.match(this.getKey());
    }

    public static String parseKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            return ROOT;
        }
        String normalizedKey = key;
        normalizedKey = normalizedKey.replace('\\', '/');
        normalizedKey = StringUtils.trim((String)normalizedKey);
        normalizedKey = StringUtils.removeStart((String)normalizedKey, (String)SEPARATOR);
        normalizedKey = StringUtils.removeEnd((String)normalizedKey, (String)SEPARATOR);
        return normalizedKey;
    }

    @Deprecated
    @CheckForNull
    public static Directory fromIOFile(File dir, Project module) {
        String relativePathFromBasedir = new PathResolver().relativePath(module.getBaseDir(), dir);
        if (relativePathFromBasedir != null) {
            return Directory.create(relativePathFromBasedir);
        }
        return null;
    }

    @Deprecated
    public static Directory create(String relativePathFromBaseDir) {
        Directory d = new Directory();
        String normalizedPath = Directory.normalize(relativePathFromBaseDir);
        d.setKey(normalizedPath);
        d.setPath(normalizedPath);
        return d;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.getKey()).append("path", (Object)this.getPath()).toString();
    }
}

