/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.maven.project.MavenProject;
import org.sonar.api.component.Component;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.AbstractLanguage;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;

public class Project
extends Resource
implements Component {
    public static final Language NONE_LANGUAGE = new AbstractLanguage("none", "None"){

        @Override
        public String[] getFileSuffixes() {
            return new String[0];
        }
    };
    static final String MAVEN_KEY_FORMAT = "%s:%s";
    private static final String BRANCH_KEY_FORMAT = "%s:%s";
    public static final String SCOPE = "PRJ";
    private MavenProject pom;
    private String branch;
    private ProjectFileSystem fileSystem;
    private String name;
    private String description;
    private String packaging;
    private Language language;
    private Date analysisDate;
    private AnalysisType analysisType;
    private String analysisVersion;
    private Settings settings;
    private File baseDir;
    private Project parent;
    private List<Project> modules = new ArrayList<Project>();

    public Project(String key) {
        this.setKey(key);
        this.setEffectiveKey(key);
    }

    public Project(String key, String branch, String name) {
        if (StringUtils.isNotBlank((String)branch)) {
            this.setKey(String.format("%s:%s", key, branch));
            this.name = String.format("%s %s", name, branch);
        } else {
            this.setKey(key);
            this.name = name;
        }
        this.setEffectiveKey(this.getKey());
        this.branch = branch;
    }

    public String getBranch() {
        return this.branch;
    }

    public Project setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public final Project setPom(MavenProject pom) {
        this.pom = pom;
        return this;
    }

    @Deprecated
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLongName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Project setName(String name) {
        this.name = name;
        return this;
    }

    public Project setDescription(String description) {
        this.description = description;
        return this;
    }

    @Deprecated
    public Project setPackaging(String packaging) {
        this.packaging = packaging;
        return this;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public Project getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public boolean isModule() {
        return !this.isRoot();
    }

    @Deprecated
    public AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    @Deprecated
    public Project setAnalysisType(AnalysisType at) {
        this.analysisType = at;
        return this;
    }

    @Deprecated
    public boolean isLatestAnalysis() {
        return true;
    }

    @Deprecated
    public Project setLatestAnalysis(boolean b) {
        if (!b) {
            throw new UnsupportedOperationException("The analysis is always the latest one. Past analysis must be done in a chronological order.");
        }
        return this;
    }

    @Override
    @Deprecated
    public Language getLanguage() {
        return this.language;
    }

    public Project setLanguage(Language language) {
        this.language = language;
        return this;
    }

    @Deprecated
    public String getLanguageKey() {
        if (this.settings == null) {
            throw new IllegalStateException("Project is not yet initialized");
        }
        return StringUtils.defaultIfEmpty((String)this.settings.getString("sonar.language"), (String)"");
    }

    public Project setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    @Deprecated
    public Settings getSettings() {
        return this.settings;
    }

    public Project setAnalysisDate(Date analysisDate) {
        this.analysisDate = analysisDate;
        return this;
    }

    public Project setAnalysisVersion(String analysisVersion) {
        this.analysisVersion = analysisVersion;
        return this;
    }

    @Override
    public String getScope() {
        return SCOPE;
    }

    @Override
    public String getQualifier() {
        return this.isRoot() ? "TRK" : "BRC";
    }

    @Override
    public boolean matchFilePattern(String antPattern) {
        return false;
    }

    @Override
    @CheckForNull
    public Project getParent() {
        return this.parent;
    }

    public Project setParent(Project parent) {
        this.parent = parent;
        if (parent != null) {
            parent.modules.add(this);
        }
        return this;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.modules.remove(this);
        }
    }

    public List<Project> getModules() {
        return this.modules;
    }

    public String getAnalysisVersion() {
        return this.analysisVersion;
    }

    public Date getAnalysisDate() {
        return this.analysisDate;
    }

    @Deprecated
    public ProjectFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Deprecated
    public Project setFileSystem(ProjectFileSystem fs) {
        this.fileSystem = fs;
        return this;
    }

    @Deprecated
    public String getGroupId() {
        return this.pom.getGroupId();
    }

    @Deprecated
    public String getArtifactId() {
        return this.pom.getArtifactId();
    }

    @Deprecated
    public MavenProject getPom() {
        return this.pom;
    }

    public static Project createFromMavenIds(String groupId, String artifactId) {
        return Project.createFromMavenIds(groupId, artifactId, null);
    }

    public static Project createFromMavenIds(String groupId, String artifactId, @Nullable String branch) {
        return new Project(String.format("%s:%s", groupId, artifactId), branch, "");
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("key", (Object)this.getKey()).append("qualifier", (Object)this.getQualifier()).toString();
    }

    @Override
    public String key() {
        return this.getKey();
    }

    @Override
    public String name() {
        return this.getName();
    }

    @Override
    public String path() {
        return this.getPath();
    }

    @Override
    public String longName() {
        return this.getLongName();
    }

    @Override
    public String qualifier() {
        return this.getQualifier();
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    File getBaseDir() {
        return this.baseDir;
    }

    @Deprecated
    public static enum AnalysisType {
        STATIC,
        DYNAMIC,
        REUSE_REPORTS;


        public boolean isDynamic(boolean includeReuseReportMode) {
            return this.equals((Object)DYNAMIC) || this.equals((Object)REUSE_REPORTS) && includeReuseReportMode;
        }
    }
}

