/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Duration
implements Serializable {
    public static final String DAY = "d";
    public static final String HOUR = "h";
    public static final String MINUTE = "min";
    private static final short MINUTES_IN_ONE_HOUR = 60;
    private final long durationInMinutes;

    private Duration(long durationInMinutes) {
        this.durationInMinutes = durationInMinutes;
    }

    private Duration(int days, int hours, int minutes, int hoursInDay) {
        this(days * hoursInDay * 60 + hours * 60 + minutes);
    }

    public static Duration create(long durationInMinutes) {
        return new Duration(durationInMinutes);
    }

    public static Duration decode(String text, int hoursInDay) {
        int days = 0;
        int hours = 0;
        int minutes = 0;
        String sanitizedText = StringUtils.deleteWhitespace((String)text);
        Pattern pattern = Pattern.compile("\\s*+(?:(\\d++)\\s*+d)?+\\s*+(?:(\\d++)\\s*+h)?+\\s*+(?:(\\d++)\\s*+min)?+\\s*+");
        Matcher matcher = pattern.matcher(text);
        try {
            if (matcher.find()) {
                String minutesText;
                String hoursText;
                String daysDuration = matcher.group(1);
                if (daysDuration != null) {
                    days = Integer.parseInt(daysDuration);
                    sanitizedText = sanitizedText.replace(daysDuration + DAY, "");
                }
                if ((hoursText = matcher.group(2)) != null) {
                    hours = Integer.parseInt(hoursText);
                    sanitizedText = sanitizedText.replace(hoursText + HOUR, "");
                }
                if ((minutesText = matcher.group(3)) != null) {
                    minutes = Integer.parseInt(minutesText);
                    sanitizedText = sanitizedText.replace(minutesText + MINUTE, "");
                }
                if (sanitizedText.isEmpty()) {
                    return new Duration(days, hours, minutes, hoursInDay);
                }
            }
            throw Duration.invalid(text, null);
        }
        catch (NumberFormatException e) {
            throw Duration.invalid(text, e);
        }
    }

    public String encode(int hoursInDay) {
        int days = Double.valueOf((double)this.durationInMinutes / (double)hoursInDay / 60.0).intValue();
        Long remainingDuration = this.durationInMinutes - (long)(days * hoursInDay * 60);
        int hours = Double.valueOf(remainingDuration.doubleValue() / 60.0).intValue();
        remainingDuration = remainingDuration - (long)(hours * 60);
        int minutes = remainingDuration.intValue();
        StringBuilder stringBuilder = new StringBuilder();
        if (days > 0) {
            stringBuilder.append(days);
            stringBuilder.append(DAY);
        }
        if (hours > 0) {
            stringBuilder.append(hours);
            stringBuilder.append(HOUR);
        }
        if (minutes > 0) {
            stringBuilder.append(minutes);
            stringBuilder.append(MINUTE);
        }
        return stringBuilder.toString();
    }

    public long toMinutes() {
        return this.durationInMinutes;
    }

    public boolean isGreaterThan(Duration other) {
        return this.toMinutes() > other.toMinutes();
    }

    public Duration add(Duration with) {
        return Duration.create(this.durationInMinutes + with.durationInMinutes);
    }

    public Duration subtract(Duration with) {
        return Duration.create(this.durationInMinutes - with.durationInMinutes);
    }

    public Duration multiply(int factor) {
        return Duration.create(this.durationInMinutes * (long)factor);
    }

    private static IllegalArgumentException invalid(String text, @Nullable Exception e) {
        throw new IllegalArgumentException(String.format("Duration '%s' is invalid, it should use the following sample format : 2d 10h 15min", text), e);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration that = (Duration)o;
        return this.durationInMinutes == that.durationInMinutes;
    }

    public int hashCode() {
        return (int)(this.durationInMinutes ^ this.durationInMinutes >>> 32);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

