/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.sonar.api.utils.XmlParserException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XpathParser {
    private static final String CAN_NOT_PARSE_XML = "can not parse xml : ";
    private Element root = null;
    private Document doc = null;
    private DocumentBuilder builder;
    private XPath xpath;
    private Map<String, XPathExpression> compiledExprs = new HashMap<String, XPathExpression>();

    public XpathParser() {
        DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
        try {
            bf.setFeature("http://apache.org/xml/features/validation/schema", false);
            bf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            bf.setFeature("http://xml.org/sax/features/validation", false);
            bf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            bf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            bf.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (ParserConfigurationException e) {
            Logger log = Loggers.get(this.getClass().getName());
            log.error("Error occured during features set up.", e);
        }
        try {
            bf.setNamespaceAware(false);
            bf.setValidating(false);
            this.builder = bf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlParserException("can not create a XML parser", e);
        }
    }

    public void parse(@Nullable File file) {
        if (file == null || !file.exists()) {
            throw new XmlParserException("File not found : " + file);
        }
        BufferedReader buffer = null;
        try {
            buffer = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
            this.parse(buffer);
        }
        catch (IOException e) {
            try {
                throw new XmlParserException("can not parse the file " + file.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(buffer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)buffer);
    }

    public void parse(InputStream stream) {
        BufferedReader buffer = null;
        try {
            buffer = new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8));
            this.parse(buffer);
        }
        catch (IOException e) {
            try {
                throw new XmlParserException("can not parse the stream", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(buffer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)buffer);
    }

    private void parse(BufferedReader buffer) throws IOException {
        this.parse(IOUtils.toString((Reader)buffer));
    }

    public void parse(String xml) {
        try {
            String fixedXml = this.fixUnicodeChar(xml);
            this.doc = this.builder.parse(new ByteArrayInputStream(fixedXml.getBytes(Charsets.UTF_8)));
            XPathFactory factory = XPathFactory.newInstance();
            this.xpath = factory.newXPath();
        }
        catch (IOException | SAXException e) {
            throw new XmlParserException(CAN_NOT_PARSE_XML + xml, e);
        }
    }

    public Element getRoot() {
        if (this.root == null && this.doc != null) {
            this.root = this.doc.getDocumentElement();
        }
        return this.root;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element getChildElement(Element base, String elementName) {
        NodeList childrens = base.getElementsByTagName(elementName);
        for (int i = 0; i < childrens.getLength(); ++i) {
            Node nde = childrens.item(i);
            if (nde.getNodeType() != 1) continue;
            return (Element)nde;
        }
        return null;
    }

    public Element getChildElement(String elementName) {
        NodeList childrens = this.getRoot().getElementsByTagName(elementName);
        for (int i = 0; i < childrens.getLength(); ++i) {
            Node nde = childrens.item(i);
            if (nde.getNodeType() != 1) continue;
            return (Element)nde;
        }
        return null;
    }

    public List<Element> getChildElements(String elementName) {
        ArrayList<Element> rtrVal = new ArrayList<Element>();
        NodeList childrens = this.getRoot().getElementsByTagName(elementName);
        for (int i = 0; i < childrens.getLength(); ++i) {
            Node nde = childrens.item(i);
            if (nde.getNodeType() != 1) continue;
            rtrVal.add((Element)nde);
        }
        return rtrVal;
    }

    public List<Element> getChildElements(Element base, String elementName) {
        ArrayList<Element> rtrVal = new ArrayList<Element>();
        NodeList childrens = base.getElementsByTagName(elementName);
        for (int i = 0; i < childrens.getLength(); ++i) {
            Node nde = childrens.item(i);
            if (nde.getNodeType() != 1) continue;
            rtrVal.add((Element)nde);
        }
        return rtrVal;
    }

    public String getChildElementValue(Element base, String elementName) {
        NodeList childrens = base.getElementsByTagName(elementName);
        for (int i = 0; i < childrens.getLength(); ++i) {
            if (childrens.item(i).getNodeType() != 1) continue;
            return childrens.item(i).getFirstChild().getNodeValue();
        }
        return null;
    }

    public String getElementValue(Node base) {
        if (base.getNextSibling() != null && base.getNextSibling().getNodeType() == 3) {
            return base.getNextSibling().getNodeValue();
        }
        if (base.getFirstChild() != null && base.getFirstChild().getNodeType() == 3) {
            return base.getFirstChild().getNodeValue();
        }
        return null;
    }

    public String getChildElementValue(String elementName) {
        NodeList childrens = this.getRoot().getElementsByTagName(elementName);
        for (int i = 0; i < childrens.getLength(); ++i) {
            if (childrens.item(i).getNodeType() != 1) continue;
            return childrens.item(i).getFirstChild().getNodeValue();
        }
        return null;
    }

    public Object executeXPath(Node node, QName qname, String xPathExpression) {
        XPathExpression expr = this.compiledExprs.get(xPathExpression);
        try {
            if (expr == null) {
                expr = this.xpath.compile(xPathExpression);
                this.compiledExprs.put(xPathExpression, expr);
            }
            return expr.evaluate(node, qname);
        }
        catch (XPathExpressionException e) {
            throw new XmlParserException("Unable to evaluate xpath expression :" + xPathExpression, e);
        }
    }

    public String executeXPath(String xPathExpression) {
        return (String)this.executeXPath(this.doc, XPathConstants.STRING, xPathExpression);
    }

    public String executeXPath(Node node, String xPathExpression) {
        return (String)this.executeXPath(node, XPathConstants.STRING, xPathExpression);
    }

    public NodeList executeXPathNodeList(String xPathExpression) {
        return (NodeList)this.executeXPath(this.doc, XPathConstants.NODESET, xPathExpression);
    }

    public NodeList executeXPathNodeList(Node node, String xPathExpression) {
        return (NodeList)this.executeXPath(node, XPathConstants.NODESET, xPathExpression);
    }

    public Node executeXPathNode(Node node, String xPathExpression) {
        return (Node)this.executeXPath(node, XPathConstants.NODE, xPathExpression);
    }

    protected String fixUnicodeChar(String text) {
        String unicode = "&u";
        StringBuilder replace = new StringBuilder(text);
        if (text.indexOf(unicode) >= 0) {
            Pattern p = Pattern.compile("&u([0-9a-fA-F]{1,4});");
            Matcher m = p.matcher(replace.toString());
            int nbFind = 0;
            while (m.find()) {
                replace.replace(m.start() + nbFind, m.end() + nbFind, "&#x" + m.group(1) + ";");
                ++nbFind;
            }
        }
        return replace.toString();
    }
}

