/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class ZipUtils {
    private static final String ERROR_CREATING_DIRECTORY = "Error creating directory: ";

    private ZipUtils() {
    }

    public static File unzip(File zip, File toDir) throws IOException {
        ZipUtils.unzip(zip, toDir, new ZipEntryFilter(){

            @Override
            public boolean accept(ZipEntry entry) {
                return true;
            }
        });
        return toDir;
    }

    public static File unzip(InputStream zip, File toDir) throws IOException {
        ZipUtils.unzip(zip, toDir, new ZipEntryFilter(){

            @Override
            public boolean accept(ZipEntry entry) {
                return true;
            }
        });
        return toDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(InputStream stream, File toDir, ZipEntryFilter filter) throws IOException {
        if (!toDir.exists()) {
            FileUtils.forceMkdir((File)toDir);
        }
        try (ZipInputStream zipStream = new ZipInputStream(stream);){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                if (!filter.accept(entry)) continue;
                File to = new File(toDir, entry.getName());
                if (entry.isDirectory()) {
                    ZipUtils.throwExceptionIfDirectoryIsNotCreatable(to);
                    continue;
                }
                File parent = to.getParentFile();
                ZipUtils.throwExceptionIfDirectoryIsNotCreatable(parent);
                ZipUtils.copy(zipStream, to);
            }
            File file = toDir;
            return file;
        }
    }

    private static void throwExceptionIfDirectoryIsNotCreatable(File to) throws IOException {
        if (to != null && !to.exists() && !to.mkdirs()) {
            throw new IOException(ERROR_CREATING_DIRECTORY + to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(File zip, File toDir, ZipEntryFilter filter) throws IOException {
        if (!toDir.exists()) {
            FileUtils.forceMkdir((File)toDir);
        }
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!filter.accept(entry)) continue;
                File to = new File(toDir, entry.getName());
                if (entry.isDirectory()) {
                    ZipUtils.throwExceptionIfDirectoryIsNotCreatable(to);
                    continue;
                }
                File parent = to.getParentFile();
                ZipUtils.throwExceptionIfDirectoryIsNotCreatable(parent);
                ZipUtils.copy(zipFile, entry, to);
            }
            File file = toDir;
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(ZipInputStream zipStream, File to) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(to);
            IOUtils.copy((InputStream)zipStream, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(ZipFile zipFile, ZipEntry entry, File to) throws IOException {
        FileOutputStream fos = new FileOutputStream(to);
        InputStream input = null;
        try {
            input = zipFile.getInputStream(entry);
            IOUtils.copy((InputStream)input, (OutputStream)fos);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(File dir, File zip) throws IOException {
        FileOutputStream out = null;
        ZipOutputStream zout = null;
        try {
            out = FileUtils.openOutputStream((File)zip);
            zout = new ZipOutputStream(out);
            ZipUtils.zip(dir, zout);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zout);
            IOUtils.closeQuietly((OutputStream)out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)zout);
        IOUtils.closeQuietly((OutputStream)out);
    }

    private static void doZip(String entryName, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doZip(String entryName, File file, ZipOutputStream out) throws IOException {
        if (file.isDirectory()) {
            entryName = entryName + '/';
            ZipEntry entry = new ZipEntry(entryName);
            out.putNextEntry(entry);
            out.closeEntry();
            File[] files = file.listFiles();
            int i = 0;
            int len = files.length;
            while (i < len) {
                ZipUtils.doZip(entryName + files[i].getName(), files[i], out);
                ++i;
            }
            return;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            ZipUtils.doZip(entryName, in, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    private static void zip(File file, ZipOutputStream out) throws IOException {
        for (File child : file.listFiles()) {
            String name = child.getName();
            ZipUtils.doZip(name, child, out);
        }
    }

    public static interface ZipEntryFilter {
        public boolean accept(ZipEntry var1);
    }
}

