/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.command;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sonar.api.utils.command.Command;
import org.sonar.api.utils.command.CommandException;
import org.sonar.api.utils.command.StreamConsumer;
import org.sonar.api.utils.command.TimeoutException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class CommandExecutor {
    private static final Logger LOG = Loggers.get(CommandExecutor.class);
    private static final CommandExecutor INSTANCE = new CommandExecutor();

    private CommandExecutor() {
    }

    public static CommandExecutor create() {
        return INSTANCE;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(Command command, StreamConsumer stdOut, StreamConsumer stdErr, long timeoutMilliseconds) {
        int n;
        ExecutorService executorService = null;
        Process process = null;
        StreamGobbler outputGobbler = null;
        StreamGobbler errorGobbler = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(command.toStrings(false));
            if (command.getDirectory() != null) {
                builder.directory(command.getDirectory());
            }
            builder.environment().putAll(command.getEnvironmentVariables());
            process = builder.start();
            outputGobbler = new StreamGobbler(process.getInputStream(), stdOut);
            errorGobbler = new StreamGobbler(process.getErrorStream(), stdErr);
            outputGobbler.start();
            errorGobbler.start();
            final Process finalProcess = process;
            executorService = Executors.newSingleThreadExecutor();
            Future<Integer> ft = executorService.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return finalProcess.waitFor();
                }
            });
            int exitCode = timeoutMilliseconds < 0L ? ft.get().intValue() : ft.get(timeoutMilliseconds, TimeUnit.MILLISECONDS).intValue();
            this.waitUntilFinish(outputGobbler);
            this.waitUntilFinish(errorGobbler);
            this.verifyGobbler(command, outputGobbler, "stdOut");
            this.verifyGobbler(command, errorGobbler, "stdErr");
            n = exitCode;
        }
        catch (java.util.concurrent.TimeoutException te) {
            try {
                process.destroy();
                throw new TimeoutException(command, "Timeout exceeded: " + timeoutMilliseconds + " ms", te);
                catch (CommandException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CommandException(command, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.waitUntilFinish(outputGobbler);
                this.waitUntilFinish(errorGobbler);
                this.closeStreams(process);
                if (executorService != null) {
                    executorService.shutdown();
                }
                throw throwable;
            }
        }
        this.waitUntilFinish(outputGobbler);
        this.waitUntilFinish(errorGobbler);
        this.closeStreams(process);
        if (executorService != null) {
            executorService.shutdown();
        }
        return n;
    }

    private void verifyGobbler(Command command, StreamGobbler gobbler, String type) {
        if (gobbler.getException() != null) {
            throw new CommandException(command, "Error inside " + type + " stream", gobbler.getException());
        }
    }

    public int execute(Command command, long timeoutMilliseconds) {
        LOG.info("Executing command: " + command);
        return this.execute(command, new DefaultConsumer(), new DefaultConsumer(), timeoutMilliseconds);
    }

    private void closeStreams(@Nullable Process process) {
        if (process != null) {
            Closeables.closeQuietly((Closeable)process.getInputStream());
            Closeables.closeQuietly((Closeable)process.getOutputStream());
            Closeables.closeQuietly((Closeable)process.getErrorStream());
        }
    }

    private void waitUntilFinish(@Nullable StreamGobbler thread) {
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                LOG.error("InterruptedException while waiting finish of " + thread.toString(), e);
            }
        }
    }

    private static class DefaultConsumer
    implements StreamConsumer {
        private DefaultConsumer() {
        }

        @Override
        public void consumeLine(String line) {
            LOG.info(line);
        }
    }

    private static class StreamGobbler
    extends Thread {
        private final InputStream is;
        private final StreamConsumer consumer;
        private volatile Exception exception;

        StreamGobbler(InputStream is, StreamConsumer consumer) {
            super("ProcessStreamGobbler");
            this.is = is;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.is, Charsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.consumeLine(line);
                }
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
        }

        private void consumeLine(String line) {
            if (this.exception == null) {
                try {
                    this.consumer.consumeLine(line);
                }
                catch (Exception e) {
                    this.exception = e;
                }
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

