/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.ConsoleFormatter;
import org.sonar.api.utils.log.LogInterceptor;
import org.sonar.api.utils.log.LoggerLevel;

class ListInterceptor
extends LogInterceptor {
    private final List<String> logs = new ArrayList<String>();
    private final ListMultimap<LoggerLevel, String> logsByLevel = ArrayListMultimap.create();

    ListInterceptor() {
    }

    @Override
    public void log(LoggerLevel level, String msg) {
        this.logs.add(msg);
        this.logsByLevel.put((Object)level, (Object)msg);
    }

    @Override
    public void log(LoggerLevel level, String msg, @Nullable Object arg) {
        String s = ConsoleFormatter.format(msg, arg);
        this.logs.add(s);
        this.logsByLevel.put((Object)level, (Object)s);
    }

    @Override
    public void log(LoggerLevel level, String msg, @Nullable Object arg1, @Nullable Object arg2) {
        String s = ConsoleFormatter.format(msg, arg1, arg2);
        this.logs.add(s);
        this.logsByLevel.put((Object)level, (Object)s);
    }

    @Override
    public void log(LoggerLevel level, String msg, Object ... args) {
        String s = ConsoleFormatter.format(msg, args);
        this.logs.add(s);
        this.logsByLevel.put((Object)level, (Object)s);
    }

    @Override
    public void log(LoggerLevel level, String msg, Throwable thrown) {
        this.logs.add(msg);
        this.logsByLevel.put((Object)level, (Object)msg);
    }

    public List<String> logs() {
        return this.logs;
    }

    public List<String> logs(LoggerLevel level) {
        return this.logsByLevel.get((Object)level);
    }

    public void clear() {
        this.logs.clear();
        this.logsByLevel.clear();
    }
}

