/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import javax.annotation.Nullable;
import org.sonar.api.utils.log.BaseLogger;
import org.sonar.api.utils.log.DefaultProfiler;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.NullProfiler;

public abstract class Profiler {
    public static Profiler create(Logger logger) {
        return new DefaultProfiler((BaseLogger)logger);
    }

    public static Profiler createIfTrace(Logger logger) {
        if (logger.isTraceEnabled()) {
            return Profiler.create(logger);
        }
        return NullProfiler.NULL_INSTANCE;
    }

    public static Profiler createIfDebug(Logger logger) {
        if (logger.isDebugEnabled()) {
            return Profiler.create(logger);
        }
        return NullProfiler.NULL_INSTANCE;
    }

    public abstract boolean isDebugEnabled();

    public abstract boolean isTraceEnabled();

    public abstract Profiler start();

    public abstract Profiler startTrace(String var1);

    public abstract Profiler startDebug(String var1);

    public abstract Profiler startInfo(String var1);

    public abstract Profiler stopTrace();

    public abstract Profiler stopDebug();

    public abstract Profiler stopInfo();

    public abstract Profiler stopTrace(String var1);

    public abstract Profiler stopDebug(String var1);

    public abstract Profiler stopInfo(String var1);

    public abstract Profiler addContext(String var1, @Nullable Object var2);
}

