/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.bytecode.asm;

import org.objectweb.asm.Type;

public class AsmType {

  private Type type;

  public AsmType(Type type) {
    this.type = type;
  }

  public boolean isArray() {
    return type.getSort() == Type.ARRAY;
  }

  public boolean isObject() {
    return type.getSort() == Type.OBJECT;
  }

  public boolean isVoid() {
    return type == Type.VOID_TYPE;
  }

  public boolean isPrimiteType() {
    return !isArray() && !isObject();
  }

  public String getPath() {
    if (isArray()) {
      return type.getElementType().getInternalName();
    } else if (isObject()) {
      return type.getInternalName();
    } else {
      throw new IllegalStateException("This AsmType is neither an Array of an Objet.");
    }
  }

}
