/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.bytecode.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.sonar.squid.api.AnalysisException;
import org.sonar.squid.bytecode.asm.AsmClass;
import org.sonar.squid.bytecode.asm.AsmClassVisitor;

public class AsmClassReader {
    public AsmClass readClass(InputStream reader) {
        try {
            AsmClassVisitor classVisitor = new AsmClassVisitor();
            ClassReader asmReader = new ClassReader(reader);
            asmReader.accept((ClassVisitor)classVisitor, 0);
            return classVisitor.getAsmClass();
        }
        catch (IOException e) {
            throw new AnalysisException("Unable to read bytecode", e);
        }
    }

    public AsmClass readClass(String className) {
        return this.readClass(ClassLoader.getSystemResourceAsStream(className));
    }

    public AsmClass readClass(File file) {
        try {
            return this.readClass(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new AnalysisException("Unable to read file : " + file.getAbsolutePath(), e);
        }
    }
}

