/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.bytecode.asm;

import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.sonar.squid.bytecode.asm.AsmSignatureVisitor;
import org.sonar.squid.bytecode.asm.AsmType;
import org.sonar.squid.bytecode.asm.AsmUnit;

public class AsmField
extends AsmUnit {
    private String name;
    private AsmType type;
    private String[] classes;

    public AsmField(int access, String name, String descriptor, String descriptorWithGenerics) {
        super(access);
        this.access = access;
        this.name = name;
        this.type = new AsmType(Type.getType((String)descriptor));
        if (descriptorWithGenerics == null) {
            this.extractClasses(descriptor);
        } else {
            this.extractClasses(descriptorWithGenerics);
        }
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    public String getName() {
        return this.name;
    }

    public AsmType getType() {
        return this.type;
    }

    public String getPath() {
        return this.type.getPath();
    }

    private void extractClasses(String signature) {
        if (signature != null) {
            AsmSignatureVisitor signatureVisitor = new AsmSignatureVisitor();
            new SignatureReader(signature).acceptType((SignatureVisitor)signatureVisitor);
            this.classes = signatureVisitor.getInternalNames().toArray(new String[0]);
        }
    }

    public String[] getClasses() {
        return this.classes;
    }

    public boolean isArray() {
        return this.type.isArray();
    }

    public boolean isObject() {
        return this.type.isObject();
    }

    public boolean isPrimiteType() {
        return this.type.isPrimiteType();
    }
}

