/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.bytecode.asm;

import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.sonar.squid.bytecode.asm.AsmSignatureVisitor;
import org.sonar.squid.bytecode.asm.AsmType;
import org.sonar.squid.bytecode.asm.AsmUnit;

public class AsmMethod
extends AsmUnit {
    String name;
    String key;
    String[] exceptions;
    AsmType returnType;
    AsmType[] arguments;
    String[] signatureClasses;

    public AsmMethod(int access, String name, String descriptor, String descriptorWithGenerics, String[] exceptions) {
        super(access);
        this.name = name;
        this.key = name + descriptor;
        this.exceptions = exceptions;
        this.initReturnType(descriptor);
        this.initArguments(descriptor);
        if (descriptorWithGenerics == null) {
            this.extractClasses(descriptor);
        } else {
            this.extractClasses(descriptorWithGenerics);
        }
    }

    private void initArguments(String descriptor) {
        Type[] types = Type.getArgumentTypes((String)descriptor);
        this.arguments = new AsmType[types.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = new AsmType(types[i]);
        }
    }

    private void extractClasses(String signature) {
        AsmSignatureVisitor signatureVisitor = new AsmSignatureVisitor();
        new SignatureReader(signature).accept((SignatureVisitor)signatureVisitor);
        this.signatureClasses = signatureVisitor.getInternalNames().toArray(new String[0]);
    }

    private void initReturnType(String descriptor) {
        this.returnType = new AsmType(Type.getReturnType((String)descriptor));
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public boolean hasReturnType() {
        return !this.returnType.isVoid();
    }

    public AsmType getReturnType() {
        return this.returnType;
    }

    public boolean hasArguments() {
        return this.arguments.length != 0;
    }

    public AsmType[] getArguments() {
        return this.arguments;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public String[] getSignatureClasses() {
        return this.signatureClasses;
    }

    public String getReturnTypePath() {
        return this.returnType.getPath();
    }
}

