/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.sonar.squid.graph.Cycle;
import org.sonar.squid.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CycleDetector {
    private final Collection<? extends Node> resourcesToAnalyze;
    private final List<Node> alreadyAnalyzed;
    private final List<Cycle> cycles = new ArrayList<Cycle>();

    public CycleDetector(Collection<? extends Node> resourcesToAnalyze) {
        this.resourcesToAnalyze = resourcesToAnalyze;
        this.alreadyAnalyzed = new ArrayList<Node>();
        this.analyze();
    }

    public CycleDetector(Node ... resources) {
        this(Arrays.asList(resources));
    }

    private void analyze() {
        for (Node node : this.resourcesToAnalyze) {
            if (this.alreadyAnalyzed.contains(node)) continue;
            this.analyze(node, new ArrayList<Node>());
        }
    }

    private void analyze(Node node, List<Node> path) {
        path.add(node);
        this.alreadyAnalyzed.add(node);
        for (Node dependency : node.dependsUpon()) {
            if (path.contains(dependency)) {
                Cycle cycle = new Cycle(new ArrayList<Node>(path.subList(path.indexOf(dependency), path.indexOf(node) + 1)));
                if (this.cycles.contains(cycle)) continue;
                this.cycles.add(cycle);
                continue;
            }
            this.analyze(dependency, new ArrayList<Node>(path));
        }
    }

    public List<Cycle> getCycles() {
        return this.cycles;
    }

    public Cycle getCycles(int cycleNumber) {
        return this.cycles.get(cycleNumber);
    }

    public int getCyclesNumber() {
        return this.cycles.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("There are " + this.getCyclesNumber() + " cycles.\n");
        for (Cycle cycle : this.cycles) {
            builder.append(cycle);
        }
        return builder.toString();
    }

    public boolean contains(Cycle cycle) {
        return this.cycles.contains(cycle);
    }
}

