/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.text;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.sonar.squid.api.AnalysisException;
import org.sonar.squid.text.EndTokenMatcher;

public class CodeReader {
    private final Reader reader;
    private int HISTORY_SIZE = 3;
    private int[] lastChars = new int[this.HISTORY_SIZE];

    public CodeReader(Reader reader) {
        this.reader = new BufferedReader(reader);
        for (int i = 0; i < this.lastChars.length; ++i) {
            this.lastChars[i] = -1;
        }
    }

    public CodeReader(String code) {
        this(new StringReader(code));
    }

    private int read() throws IOException {
        if (!this.reader.ready()) {
            return -1;
        }
        return this.reader.read();
    }

    public final void mark(int readAheadLimit) throws IOException {
        if (this.reader.markSupported()) {
            throw new AnalysisException("Mark are not supported on provided Reader.");
        }
        this.reader.mark(readAheadLimit);
    }

    public final int lastChar() {
        return this.lastChars[0];
    }

    public final int peek() {
        try {
            this.reader.mark(1);
            int nextChar = this.read();
            this.reader.reset();
            return nextChar;
        }
        catch (IOException e) {
            throw new AnalysisException("Unable to read on input stream.", e);
        }
    }

    public final int pop() {
        try {
            this.setLastChar(this.read());
            return this.lastChar();
        }
        catch (IOException e) {
            throw new AnalysisException("Unable to read on input stream.", e);
        }
    }

    private void setLastChar(int read) {
        for (int i = this.lastChars.length - 1; i > 0; --i) {
            this.lastChars[i] = this.lastChars[i - 1];
        }
        this.lastChars[0] = read;
    }

    public String readTo(EndTokenMatcher matcher) {
        CharArrayWriter result = new CharArrayWriter();
        result.append((char)this.pop());
        while (!matcher.match(this.peek()) && this.peek() != -1) {
            result.append((char)this.pop());
        }
        return result.toString();
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new AnalysisException("Unable to close the reader on source code.", e);
        }
    }

    public char[] peek(int index) {
        try {
            char[] result = new char[index];
            this.reader.mark(index);
            this.reader.read(result, 0, index);
            this.reader.reset();
            return result;
        }
        catch (IOException e) {
            throw new AnalysisException("Unable to read on input stream.", e);
        }
    }

    public int lastChar(int index) {
        return this.lastChars[index];
    }
}

