package org.sonar.squid.graph;

import java.util.Set;


public interface Node {

  public void createEdgeWith(Node to, EdgeUsage usage);

  public void createEdgeWith(Node to, EdgeUsage usage, Edge rootEdge);

  public EdgeUsage getUsageOf(Node to);
  
  public EdgeUsage getUsageBy(Node from);

  public Edge getEdgeTo(Node to);
  
  public Edge getEdgeFrom(Node from);

  public Set<Node> dependsUpon();

  public Set<Node> dependedUpon();
  
  public String getKey();
}
