/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.api;

import java.util.HashSet;
import java.util.Set;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFile
extends SourceCode {
    Set<Integer> noSonarTagLines = new HashSet<Integer>();

    public SourceFile(String key) {
        super(key);
    }

    public SourceFile(String key, String fileName) {
        super(key, fileName);
    }

    public static SourceFile create(SourcePackage parentPackage, String fileName) {
        StringBuilder key = new StringBuilder();
        if (parentPackage != null) {
            key.append(parentPackage.getKey());
            key.append(".");
        }
        key.append(fileName);
        return new SourceFile(key.toString(), fileName);
    }

    @Override
    protected void initializeMeasures() {
        this.setMeasure(Metric.FILES, 1);
    }

    @Override
    protected void updateMeasuresAfterConsolidation() {
    }

    public Set<Integer> getNotSonarTagLines() {
        return this.noSonarTagLines;
    }

    public boolean isThereNoSonarTagAtLine(int lineNumber) {
        return this.noSonarTagLines.contains(lineNumber);
    }

    public void addNotSonarTagLines(Set<Integer> noSonarTagLines) {
        this.noSonarTagLines.addAll(noSonarTagLines);
    }
}

