/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.ast.visitor.AstVisitor;
import org.sonar.squid.indexer.SquidIndex;

public class PackageVisitor
extends AstVisitor {
    private SquidIndex indexer;

    public PackageVisitor(SquidIndex indexer) {
        this.indexer = indexer;
    }

    public void visitFile(DetailAST ast) {
        if (ast == null) {
            return;
        }
        SourceCode packageRes = this.extractPackage(ast);
        if (this.peekResource().hasChild(packageRes)) {
            packageRes = this.indexer.search(packageRes.getKey());
        }
        this.addResource(packageRes);
    }

    public void leaveFile(DetailAST ast) {
        if (ast == null) {
            return;
        }
        this.popResource();
    }

    private SourcePackage extractPackage(DetailAST ast) {
        SourcePackage packageRes;
        if (ast.getType() != 16) {
            packageRes = new SourcePackage("[default]");
        } else {
            String packageName = FullIdent.createFullIdent((DetailAST)ast.getLastChild().getPreviousSibling()).getText();
            packageRes = new SourcePackage(packageName);
        }
        return packageRes;
    }
}

