/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.bytecode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.sonar.squid.api.CodeScanner;
import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.bytecode.AsmSquidBridge;
import org.sonar.squid.bytecode.AsmVisitor;
import org.sonar.squid.bytecode.DependencyVisitor;
import org.sonar.squid.indexer.SquidIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeScanner
implements CodeScanner {
    private SquidIndex indexer;
    private List<AsmVisitor> asmVisitors = new ArrayList<AsmVisitor>();

    public BytecodeScanner(SquidIndex indexer) {
        this.indexer = indexer;
    }

    @Override
    public void scanCode(SourceCode project, Collection<File> filesToAnalyse) {
        AsmSquidBridge asmSquidBridge = new AsmSquidBridge(this.indexer, this.asmVisitors);
        for (File file : filesToAnalyse) {
            try {
                ClassReader reader = new ClassReader((InputStream)new FileInputStream(file));
                reader.accept((ClassVisitor)asmSquidBridge, 0);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void accept(CodeVisitor visitor) {
        this.asmVisitors.add((AsmVisitor)visitor);
    }

    @Override
    public Collection<Class<? extends CodeVisitor>> getVisitors() {
        ArrayList<Class<? extends CodeVisitor>> visitorClasses = new ArrayList<Class<? extends CodeVisitor>>();
        visitorClasses.add(DependencyVisitor.class);
        return visitorClasses;
    }
}

