/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.bytecode.asm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sonar.squid.bytecode.asm.AsmField;
import org.sonar.squid.bytecode.asm.AsmMethod;
import org.sonar.squid.bytecode.asm.AsmUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmClass
extends AsmUnit {
    private int version;
    private String className;
    private String signature;
    private String superClass;
    private String[] interfaces;
    private Map<String, AsmMethod> methods = new HashMap<String, AsmMethod>();
    private Map<String, AsmField> fields = new HashMap<String, AsmField>();

    public AsmClass(int version, int access, String className, String signature, String superClass, String[] interfaces) {
        super(access);
        this.version = version;
        this.className = className;
        this.signature = signature;
        this.superClass = superClass;
        this.interfaces = interfaces;
    }

    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public String getClassName() {
        return this.className;
    }

    public void addMethod(AsmMethod asmMethod) {
        this.methods.put(asmMethod.getKey(), asmMethod);
    }

    public Collection<AsmMethod> getMethods() {
        return this.methods.values();
    }

    public Collection<AsmField> getFields() {
        return this.fields.values();
    }

    public void addField(AsmField field) {
        this.fields.put(field.getName(), field);
    }

    public AsmField getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public AsmMethod getMethod(String key) {
        return this.methods.get(key);
    }
}

