/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.graph;

import java.util.Arrays;
import java.util.List;
import org.sonar.squid.graph.Edge;
import org.sonar.squid.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cycle {
    private List<Node> nodes;
    private int hashCode;

    public Cycle(List<Node> nodes) {
        this.nodes = nodes;
        this.hashCode = 0;
        for (Node node : nodes) {
            this.hashCode += node.hashCode();
        }
    }

    public Cycle(Node ... nodes) {
        this(Arrays.asList(nodes));
    }

    public int getCycleLength() {
        return this.nodes.size();
    }

    public boolean contains(Node resource) {
        return this.nodes.contains(resource);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Edge weaker = this.getWeakerEdge();
        builder.append("Cycle between " + this.getCycleLength() + " resources : \n");
        for (Node from : this.nodes) {
            Edge relation = this.getEdgeFrom(from);
            String weakerFlag = "   ";
            if (weaker.equals(relation)) {
                weakerFlag = " * ";
            }
            builder.append(weakerFlag + relation.getFrom().getKey() + " --" + relation.getWeight() + "--> " + "\n");
        }
        return builder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Cycle)) {
            return false;
        }
        return this.hashCode == object.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Edge getWeakerEdge() {
        Edge weaker = null;
        for (Node from : this.nodes) {
            Edge relation = this.getEdgeFrom(from);
            if (weaker != null && weaker.getWeight() <= relation.getWeight()) continue;
            weaker = relation;
        }
        return weaker;
    }

    private Edge getEdgeFrom(Node from) {
        int index = this.nodes.indexOf(from);
        Node to = this.nodes.get(index + 1 < this.nodes.size() ? index + 1 : 0);
        return from.getEdgeTo(to);
    }
}

