/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.measures;

import org.sonar.squid.measures.AbstractnessFormula;
import org.sonar.squid.measures.AggregationFormula;
import org.sonar.squid.measures.CalculatedMetricFormula;
import org.sonar.squid.measures.CommentLinesDensityFormula;
import org.sonar.squid.measures.CommentLinesWithoutHeaderFormula;
import org.sonar.squid.measures.DistanceFormula;
import org.sonar.squid.measures.InstabilityFormula;
import org.sonar.squid.measures.NoAggregationFormula;
import org.sonar.squid.measures.PublicDocumentedApiDensityFormula;
import org.sonar.squid.measures.SumAggregationFormula;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Metric {
    PACKAGES,
    CLASSES,
    FILES,
    METHODS,
    STATEMENTS,
    LINES(false),
    BLANK_LINES(false),
    COMMENT_LINES(false),
    HEADER_COMMENT_LINES(false),
    COMMENTED_OUT_CODE_LINES(false),
    BRANCHES,
    PUBLIC_API,
    PUBLIC_DOC_API,
    ACCESSORS,
    COMMENT_BLANK_LINES(false),
    LINES_OF_CODE(false),
    COMMENT_LINES_WITHOUT_HEADER(new CommentLinesWithoutHeaderFormula()),
    PUBLIC_DOCUMENTED_API_DENSITY(new PublicDocumentedApiDensityFormula()),
    COMMENT_LINES_DENSITY(new CommentLinesDensityFormula()),
    COMPLEXITY,
    INTERFACES,
    ABSTRACT_CLASSES,
    ABSTRACTNESS(new AbstractnessFormula()),
    CA(new NoAggregationFormula()),
    CE(new NoAggregationFormula()),
    INSTABILITY(new InstabilityFormula()),
    DISTANCE(new DistanceFormula());

    private double initValue = 0.0;
    private CalculatedMetricFormula formula = null;
    private AggregationFormula aggregationFormula = new SumAggregationFormula();
    private boolean aggregateIfThereIsAlreadyAValue = true;

    private Metric() {
    }

    private Metric(boolean aggregateIfThereIsAlreadyAValue) {
        this.aggregateIfThereIsAlreadyAValue = aggregateIfThereIsAlreadyAValue;
    }

    private Metric(AggregationFormula aggregationFormula) {
        this.aggregationFormula = aggregationFormula;
    }

    private Metric(CalculatedMetricFormula formula) {
        this.formula = formula;
    }

    public double getInitValue() {
        return this.initValue;
    }

    public boolean isCalculatedMetric() {
        return this.formula != null;
    }

    public boolean aggregateIfThereIsAlreadyAValue() {
        return this.aggregateIfThereIsAlreadyAValue;
    }

    public boolean isThereAggregationFormula() {
        return !(this.aggregationFormula instanceof NoAggregationFormula);
    }

    public CalculatedMetricFormula getCalculatedMetricFormula() {
        return this.formula;
    }

    public AggregationFormula getAggregationFormula() {
        return this.aggregationFormula;
    }
}

