/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.text.colorizer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonar.squid.text.CodeReader;
import org.sonar.squid.text.EndTokenMatcher;
import org.sonar.squid.text.colorizer.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordsTokenizer
extends Tokenizer {
    private Set<String> keywords = new HashSet<String>();
    private EndTokenMatcher endTokenMatcher = new EndTokenMatcher(){

        public boolean match(int endFlag) {
            return !Character.isJavaIdentifierPart(endFlag);
        }
    };

    public KeywordsTokenizer(String tagBefore, String tagAfter, Set<String> keywords) {
        super(tagBefore, tagAfter);
        this.keywords = keywords;
    }

    public KeywordsTokenizer(String tagBefore, String tagAfter, String ... keywords) {
        super(tagBefore, tagAfter);
        Collections.addAll(this.keywords, keywords);
    }

    public KeywordsTokenizer(String keyword) {
        this("", "", keyword);
    }

    @Override
    public boolean hasNextToken(CodeReader code) {
        return Character.isJavaIdentifierStart(code.peek());
    }

    @Override
    public String nextToken(CodeReader code) {
        String keyword = code.readTo(this.endTokenMatcher);
        return this.keywords.contains(keyword) ? this.tagBefore + keyword + this.tagAfter : keyword;
    }
}

