/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.bytecode.asm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.objectweb.asm.Opcodes;

public class AsmClass extends AsmUnit {

  private int                    version;
  private String                 className;
  private String                 signature;
  private String                 superClass;
  private String[]               interfaces;
  private Map<String, AsmMethod> methods = new HashMap<String, AsmMethod>();
  private Map<String, AsmField>  fields  = new HashMap<String, AsmField>();

  public AsmClass(int version, int access, String className, String signature, String superClass, String[] interfaces) {
    super(access);
    this.version = version;
    this.className = className;
    this.signature = signature;
    this.superClass = superClass;
    this.interfaces = interfaces;
  }

  public boolean isAbstract() {
    return (access & Opcodes.ACC_ABSTRACT) != 0;
  }

  public boolean isInterface() {
    return (access & Opcodes.ACC_INTERFACE) != 0;
  }

  public String getClassName() {
    return className;
  }

  public void addMethod(AsmMethod asmMethod) {
    methods.put(asmMethod.getKey(), asmMethod);
  }

  public Collection<AsmMethod> getMethods() {
    return methods.values();
  }

  public Collection<AsmField> getFields() {
    return fields.values();
  }

  public void addField(AsmField field) {
    fields.put(field.getName(), field);
  }

  public AsmField getField(String fieldName) {
    return fields.get(fieldName);
  }

  public AsmMethod getMethod(String key) {
    return methods.get(key);
  }
}
