/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.text.colorizer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PlsqlKeywords {

  private PlsqlKeywords() {
  }

  public final static Set<String> get() {
    String[] plsqlKeywords = { "ALL", "ALTER", "AND", "ANY", "ARRAY", "ARROW", "AS", "ASC", "AT", "BEGIN", "BETWEEN", "BY", "CASE",
        "CHECK", "CLUSTERS", "CLUSTER", "COLAUTH", "COLUMNS", "COMPRESS", "CONNECT", "CRASH", "CREATE", "CURRENT", "DECIMAL", "DECLARE",
        "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "END", "EXCEPTION", "EXCLUSIVE", "EXISTS", "FETCH", "FORM", "FOR", "FROM",
        "GOTO", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IF", "IN", "INDEXES", "INDEX", "INSERT", "INTERSECT", "INTO", "IS", "LIKE",
        "LOCK", "MINUS", "MODE", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "OF", "ON", "OPTION", "OR", "ORDER", "OVERLAPS", "PRIOR",
        "PROCEDURE", "PUBLIC", "RANGE", "RECORD", "RESOURCE", "REVOKE", "SELECT", "SHARE", "SIZE", "SQL", "START", "SUBTYPE", "TABAUTH",
        "TABLE", "THEN", "TO", "TYPE,UNION", "UNIQUE", "UPDATE", "USE", "VALUES", "VIEW", "VIEWS", "WHEN", "WHERE", "WITH", "A", "ADD",
        "AGENT", "AGGREGATE", "ARRAY", "ATTRIBUTE", "AUTHID", "AVG", "BFILE_BASE", "BINARY", "BLOB_BASE", "BLOCK", "BODY", "BOTH", "BOUND",
        "BULK", "BYTE", "C", "CALL", "CALLING", "CASCADE", "CHAR", "CHAR_BASE", "CHARACTER", "CHARSETFORM", "CHARSETID", "CHARSET",
        "CLOB_BASE", "CLOSE", "COLLECT", "COMMENT", "COMMIT", "COMMITTED", "COMPILED", "CONSTANT", "CONSTRUCTOR", "CONTEXT", "CONVERT",
        "COUNT", "CURSOR", "CUSTOMDATUM", "DANGLING", "DATA", "DATE", "DATE_BASE", "DAY", "DEFINE", "DETERMINISTIC", "DOUBLE", "DURATION",
        "ELEMENT", "ELSIF", "EMPTY", "ESCAPE", "EXCEPT", "EXCEPTIONS", "EXECUTE", "EXIT", "EXTERNAL", "FINAL", "FIXED", "FLOAT", "FORALL",
        "FORCE", "FUNCTION", "GENERAL", "HASH", "HEAP", "HIDDEN", "HOUR", "IMMEDIATE", "INCLUDING", "INDICATOR", "INDICES", "INFINITE",
        "INSTANTIABLE", "INT", "INTERFACE", "INTERVAL", "INVALIDATE", "ISOLATION", "JAVA", "LANGUAGE", "LARGE", "LEADING", "LENGTH",
        "LEVEL", "LIBRARY", "LIKE2", "LIKE4", "LIKEC", "LIMIT", "LIMITED", "LOCAL", "LONG", "LOOP", "MAP", "MAX", "MAXLEN", "MEMBER",
        "MERGE", "MIN", "MINUTE", "MOD", "MODIFY", "MONTH", "MULTISET", "NAME", "NAN", "NATIONAL", "NATIVE", "NCHAR", "NEW", "NOCOPY",
        "NUMBER_BASE", "OBJECT", "OCICOLL", "OCIDATETIME", "OCIDATE", "OCIDURATION", "OCIINTERVAL", "OCILOBLOCATOR", "OCINUMBER", "OCIRAW",
        "OCIREFCURSOR", "OCIREF", "OCIROWID", "OCISTRING", "OCITYPE", "ONLY", "OPAQUE", "OPEN", "OPERATOR", "ORACLE", "ORADATA",
        "ORGANIZATION", "ORLANY", "ORLVARY", "OTHERS", "OUT", "OVERRIDING", "PACKAGE", "PARALLEL_ENABLE", "PARAMETER", "PARAMETERS",
        "PARTITION", "PASCAL", "PIPE", "PIPELINED", "PRAGMA", "PRECISION", "PRIVATE", "RAISE", "RANGE", "RAW", "READ", "RECORD", "REF",
        "REFERENCE", "REM", "REMAINDER", "RENAME", "RESULT", "RETURN", "RETURNING", "REVERSE", "ROLLBACK", "ROW", "SAMPLE", "SAVE",
        "SAVEPOINT", "SB1", "SB2", "SB4", "SECOND", "SEGMENT", "SELF", "SEPARATE", "SEQUENCE", "SERIALIZABLE", "SET", "SHORT", "SIZE_T",
        "SOME", "SPARSE", "SQLCODE", "SQLDATA", "SQLNAME", "SQLSTATE", "STANDARD", "STATIC", "STDDEV", "STORED", "STRING", "STRUCT",
        "STYLE", "SUBMULTISET", "SUBPARTITION", "SUBSTITUTABLE", "SUBTYPE", "SUM", "SYNONYM", "TDO", "THE", "TIME", "TIMESTAMP",
        "TIMEZONE_ABBR", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TIMEZONE_REGION", "TRAILING", "TRANSAC", "TRANSACTIONAL", "TRUSTED", "TYPE",
        "UB1", "UB2", "UB4", "UNDER", "UNSIGNED", "UNTRUSTED", "USE", "USING", "VALIST", "VALUE", "VARIABLE", "VARIANCE", "VARRAY",
        "VARYING", "VOID", "WHILE", "WORK", "WRAPPED", "WRITE", "YEAR", "ZONE" };
    Set<String> keywords = new HashSet<String>();
    Collections.addAll(keywords, plsqlKeywords);
    return keywords;
  }
}
