/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.api;

import java.util.HashSet;
import java.util.Set;

import org.sonar.squid.measures.Metric;

public class SourceFile extends SourceCode {

  Set<Integer> noSonarTagLines = new HashSet<Integer>();

  public SourceFile(String key) {
    super(key);
  }

  public SourceFile(String key, String fileName) {
    super(key, fileName);
  }

  public static SourceFile create(SourcePackage parentPackage, String fileName) {
    StringBuilder key = new StringBuilder();
    if (parentPackage != null) {
      key.append(parentPackage.getKey());
      key.append(".");
    }
    key.append(fileName);
    return new SourceFile(key.toString(), fileName);
  }

  @Override
  protected void initializeMeasures() {
    setMeasure(Metric.FILES, 1);
  }

  @Override
  protected void updateMeasuresAfterConsolidation() {
  }

  public Set<Integer> getNotSonarTagLines() {
    return noSonarTagLines;
  }

  public boolean isThereNoSonarTagAtLine(int lineNumber) {
    return noSonarTagLines.contains(lineNumber);
  }

  public void addNotSonarTagLines(Set<Integer> noSonarTagLines) {
    this.noSonarTagLines.addAll(noSonarTagLines);
  }
}
