/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.api;

import java.nio.charset.Charset;

public class SquidConfiguration {

  private boolean analysePropertyAccessors = true;

  private Charset charset                  = Charset.defaultCharset();

  private double  commentedCodeThreshold   = 0.9;

  public SquidConfiguration() {
  }

  public SquidConfiguration(boolean analysePropertyAccessors) {
    this.analysePropertyAccessors = analysePropertyAccessors;
  }

  public SquidConfiguration(double commentedCodeThreshold) {
    setCommentedCodeThreshold(commentedCodeThreshold);
  }

  public SquidConfiguration(boolean analysePropertyAccessors, Charset charset) {
    this.analysePropertyAccessors = analysePropertyAccessors;
    this.charset = charset;
  }

  public SquidConfiguration(boolean analysePropertyAccessors, Charset charset, double commentedCodeThreshold) {
    this.analysePropertyAccessors = analysePropertyAccessors;
    this.charset = charset;
    setCommentedCodeThreshold(commentedCodeThreshold);
  }

  public boolean isAnalysePropertyAccessors() {
    return analysePropertyAccessors;
  }

  public Charset getCharset() {
    return charset;
  }

  public void setCharset(Charset charset) {
    this.charset = charset;
  }

  private void setCommentedCodeThreshold(double commentedCodeThreshold) {
    if (commentedCodeThreshold < 0 || commentedCodeThreshold > 1) {
      throw new IllegalArgumentException("Commented Code Threshold should be between [0...1]. Current value : " + commentedCodeThreshold);
    }
    this.commentedCodeThreshold = commentedCodeThreshold;
  }

  public double getCommentedCodeThreshold() {
    return commentedCodeThreshold;
  }
}