package org.sonar.squid.api;

import java.util.Observable;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class TreeNode<E extends TreeNode> extends Observable {

  private TreeNode     parent;
  private SortedSet<E> children = new TreeSet<E>();

  public E addChild(E resource) {
    resource.setParent(this);
    if (!children.contains(resource)) {
      children.add(resource);
      setChanged();
      notifyObservers(resource);
    }
    return (E) this;
  }

  public E getParent(Class<? extends TreeNode> squidUnit) {
    if (parent == null) {
      return null;
    } else if (parent.getClass().equals(squidUnit)) {
      return (E) parent;
    } else {
      return (E) parent.getParent(squidUnit);
    }
  }

  public E getFirstChild() {
    return !children.isEmpty() ? children.first() : null;
  }

  public E getLastChild() {
    return !children.isEmpty() ? children.last() : null;
  }

  private void setParent(TreeNode parent) {
    this.parent = parent;
  }

  public E getParent() {
    return (E) parent;
  }

  public Set<E> getChildren() {
    return children;
  }

  public boolean hasChild(TreeNode squidUnit) {
    if (children.contains(squidUnit)) {
      return true;
    }
    for (TreeNode child : children) {
      if (child.hasChild(squidUnit)) {
        return true;
      }
    }
    return false;
  }

  public boolean hasAmongParents(TreeNode expectedParent) {
    if (parent == null) {
      return false;
    } else if (parent.equals(expectedParent)) {
      return true;
    } else {
      return parent.hasAmongParents(expectedParent);
    }
  }

}
